/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SablesPesadoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SablesPesadoAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float CHARGE_BONUS = 0.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sables_pesado", new Pair[]{ImmutablePair.of((Object)"The user compresses a sandstorm to its limits and shoots it at extreme speeds.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and charge time is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(50.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 500;
    private static final int CHARGE_TIME = 100;
    public static final AbilityCore<SablesPesadoAbility> INSTANCE = new AbilityCore.Builder<SablesPesadoAbility>("Sables: Pesado", AbilityCategory.DEVIL_FRUITS, SablesPesadoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(500.0f), ChargeComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private Interval particleInterval = new Interval(5);

    public SablesPesadoAbility(AbilityCore<SablesPesadoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.getMaxChargeBonusManager().removeBonus(SunaHelper.DESERT_CHARGE_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.chargeComponent.getMaxChargeBonusManager().addBonus(SunaHelper.DESERT_CHARGE_BONUS, "Desert Charge Bonus", BonusOperation.MUL, 0.5f);
        }
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.REDUCED_FALL.get(), 2, 1, false, false));
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SABLES_PESADO.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SABLES_PESADO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.projectileComponent.shoot(entity, 3.25f, 4.0f);
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }

    private SablesPesadoProjectile createProjectile(LivingEntity entity) {
        SablesPesadoProjectile proj = new SablesPesadoProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

