/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.FlyAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.BarjanAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.GrandeSablesAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SunaFlyAbility
extends FlyAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "suna_special_fly", new Pair[]{ImmutablePair.of((Object)"Allows the user to fly, cannot be used while the user is wet", null)});
    public static final AbilityCore<SunaFlyAbility> INSTANCE = new AbilityCore.Builder<SunaFlyAbility>("Suna Special Fly", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, SunaFlyAbility::new).addDescriptionLine(DESCRIPTION).build();

    public SunaFlyAbility(AbilityCore<SunaFlyAbility> core) {
        super((AbilityCore)core);
    }

    @Override
    public AbilityUseResult canUse(LivingEntity entity) {
        if (SunaHelper.isWet(entity)) {
            return AbilityUseResult.fail(null);
        }
        return super.canUse(entity);
    }

    @Override
    public Supplier<ParticleEffect<?>> getParticleEffects() {
        return ModParticleEffects.SUNA_FLY;
    }

    @Override
    public int getHeightDifference(PlayerEntity player) {
        return 30;
    }

    @Override
    public float getSpeedMultiplier(PlayerEntity player) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        if (abilityDataProps == null) {
            return 0.0f;
        }
        GrandeSablesAbility grandeSables = abilityDataProps.getEquippedAbility(GrandeSablesAbility.INSTANCE);
        BarjanAbility barjanAbility = abilityDataProps.getEquippedAbility(BarjanAbility.INSTANCE);
        if (grandeSables != null && grandeSables.isContinuous() || barjanAbility != null && barjanAbility.isContinuous()) {
            return 1.0f;
        }
        float speed = 0.4f;
        if (SunaHelper.isFruitBoosted((LivingEntity)player)) {
            speed = 0.75f;
        }
        if (!WyHelper.isInCombat((LivingEntity)player)) {
            speed += speed * 0.3f;
        }
        return speed;
    }
}

