/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.effects.IColorOverlayEffect;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SunaHelper {
    public static final UUID DESERT_COOLDOWN_BONUS = UUID.fromString("6d311e6b-84b8-4c9d-b67b-f93116bbc397");
    public static final UUID DESERT_DAMAGE_BONUS = UUID.fromString("9f5c3cf8-d241-4895-a33d-a2f1be34e163");
    public static final UUID DESERT_CHARGE_BONUS = UUID.fromString("415a4bf3-1c81-4b93-a705-5e5661dd0bae");
    public static final UUID DESERT_RANGE_BONUS = UUID.fromString("e5e79903-2ee4-49e5-b462-dfa51a68af0a");

    public static AbilityUseResult requiresInactiveDesertGirasole(LivingEntity entity, IAbility ability) {
        DesertGirasoleAbility desertGirasole = AbilityDataCapability.get(entity).getEquippedAbility(DesertGirasoleAbility.INSTANCE);
        if (desertGirasole != null && desertGirasole.isCharging()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{ability.getDisplayName().getString(), desertGirasole.getDisplayName().getString()}));
        }
        return AbilityUseResult.success();
    }

    public static boolean isWet(LivingEntity entity) {
        boolean holdsUmbrella;
        BlockPos blockpos = entity.func_233580_cy_();
        boolean isRaining = entity.field_70170_p.func_175727_C(blockpos) || entity.field_70170_p.func_175727_C(new BlockPos((double)blockpos.func_177958_n(), entity.func_174813_aQ().field_72337_e, (double)blockpos.func_177952_p()));
        boolean checkMainHand = !entity.func_184614_ca().func_190926_b() && entity.func_184614_ca().func_77973_b() == ModWeapons.UMBRELLA.get();
        boolean checkOffHand = !entity.func_184592_cb().func_190926_b() && entity.func_184592_cb().func_77973_b() == ModWeapons.UMBRELLA.get();
        boolean bl = holdsUmbrella = checkMainHand || checkOffHand;
        if (isRaining && holdsUmbrella) {
            return false;
        }
        return entity.func_70026_G();
    }

    @Deprecated
    public static int getReducedCooldown(LivingEntity player, int defaultValue) {
        if (SunaHelper.isFruitBoosted(player)) {
            return (int)((double)defaultValue - WyHelper.percentage(20.0, defaultValue));
        }
        return defaultValue;
    }

    public static boolean isFruitBoosted(LivingEntity player) {
        return player.func_130014_f_().func_226691_t_(player.func_233580_cy_()).func_201856_r().equals((Object)Biome.Category.DESERT) || player.func_130014_f_().func_226691_t_(player.func_233580_cy_()).func_201856_r().equals((Object)Biome.Category.BEACH);
    }

    public static void drainLiquids(LivingEntity entity, int effects, int potions, int buckets) {
        if (entity == null || !entity.func_70089_S()) {
            return;
        }
        int cleanBottles = 0;
        int cleanBuckets = 0;
        int cleanEffects = 0;
        for (EffectInstance eff : entity.func_70651_bq()) {
            if (eff == null || effects <= cleanEffects || !eff.func_188419_a().func_188408_i() || 1 < eff.func_76458_c() || eff.func_188419_a() instanceof IColorOverlayEffect) continue;
            ++cleanEffects;
            Effect potion = eff.func_188419_a();
            entity.func_195063_d(potion);
            if (!(entity instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SRemoveEntityEffectPacket(entity.func_145782_y(), potion));
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ArrayList<Item> items = new ArrayList<Item>(Arrays.asList(Items.field_151068_bn, Items.field_185156_bI, Items.field_185155_bH));
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                BucketItem item;
                if (items.contains(player.field_71071_by.func_70301_a(i).func_77973_b()) && potions > cleanBottles) {
                    player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)Items.field_190931_a));
                    ++cleanBottles;
                    continue;
                }
                if (!(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof BucketItem) || buckets <= cleanBuckets || (item = (BucketItem)player.field_71071_by.func_70301_a(i).func_77973_b()).getFluid() == Fluids.field_204541_a || item.getFluid() == Fluids.field_204547_b) continue;
                player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)Items.field_190931_a));
                ++cleanBuckets;
            }
            if (cleanBottles > 0) {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo, cleanBottles));
            }
            if (cleanBuckets > 0) {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar, cleanBuckets));
            }
        }
    }
}

