/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.awt.Color;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class SpiderAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spider", new Pair[]{ImmutablePair.of((Object)"Hardens the user's body to protect themselves, but they're unable to move", null)});
    private static final float HOLD_TIME = 300.0f;
    private static final float MIN_COOLDOWN = 30.0f;
    private static final float MAX_COOLDOWN = 330.0f;
    public static final AbilityCore<SpiderAbility> INSTANCE = new AbilityCore.Builder<SpiderAbility>("Spider", AbilityCategory.DEVIL_FRUITS, SpiderAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(30.0f, 330.0f), ContinuousComponent.getTooltip(300.0f)).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setColor(new Color(100, 100, 100, 70)).build();
    public final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::onContinuityStops);
    public final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
    public final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    public final AnimationComponent animationComponent = new AnimationComponent(this);

    public SpiderAbility(AbilityCore<SpiderAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.poolComponent, this.skinOverlayComponent, this.animationComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
        this.skinOverlayComponent.showAll(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 3, false, false));
    }

    private void onContinuityStops(LivingEntity entity, IAbility ability) {
        float cooldown = 30.0f + this.continuousComponent.getContinueTime();
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, cooldown);
        this.skinOverlayComponent.hideAll(entity);
    }
}

