/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.supa.SpiralHollowProjectile;

public class SpiralHollowAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "spiral_hollow", new Pair[]{ImmutablePair.of((Object)"Creates circular blades along the user's forearms slicing enemies in a close line", null)});
    private static final float COOLDOWN = 180.0f;
    public static final AbilityCore<SpiralHollowAbility> INSTANCE = new AbilityCore.Builder<SpiralHollowAbility>("Spiral Hollow", AbilityCategory.DEVIL_FRUITS, SpiralHollowAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(180.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private boolean isDouble = false;

    public SpiralHollowAbility(AbilityCore<SpiralHollowAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.dealDamageComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.isDouble = true;
        if (this.isDouble) {
            Vector3d dirVec = Vector3d.field_186680_a;
            Direction dir = Direction.func_176733_a((double)entity.field_70177_z);
            dirVec = dirVec.func_72441_c((double)Math.abs(dir.func_176730_m().func_177958_n()), (double)Math.abs(dir.func_176730_m().func_177956_o()), (double)Math.abs(dir.func_176730_m().func_177952_p())).func_216372_d(1.2, 1.0, 1.2);
            double yPos = entity.func_226278_cu_() + (double)entity.func_70047_e() - 0.5;
            SpiralHollowProjectile leftProj = (SpiralHollowProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            leftProj.func_70012_b(entity.func_226277_ct_() + dirVec.field_72449_c, yPos, entity.func_226281_cx_() + dirVec.field_72450_a, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)leftProj);
            leftProj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
            SpiralHollowProjectile rightProj = (SpiralHollowProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            rightProj.func_70012_b(entity.func_226277_ct_() - dirVec.field_72449_c, yPos, entity.func_226281_cx_() - dirVec.field_72450_a, 0.0f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)rightProj);
            rightProj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
        } else {
            this.projectileComponent.shoot(entity);
        }
        entity.func_226292_a_(entity.func_184600_cs(), true);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    public void setDouble() {
        this.isDouble = true;
    }

    private SpiralHollowProjectile createProjectile(LivingEntity entity) {
        SpiralHollowProjectile proj = new SpiralHollowProjectile(entity.field_70170_p, entity);
        proj.setPassThroughEntities();
        return proj;
    }
}

