/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.swordsman;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShiShishiSonsonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shi_shishi_sonson", new Pair[]{ImmutablePair.of((Object)"The user dashes forward and rapidly slashes the opponent", null)});
    private static final float COOLDOWN = 180.0f;
    private static final int CONTINUOUS_TIME = 40;
    private static final int CHARGE_TIME = 20;
    private static final float DAMAGE = 30.0f;
    private static final float RANGE = 2.5f;
    private static final float MAX_TELEPORT_DISTANCE = 30.0f;
    public static final AbilityCore<ShiShishiSonsonAbility> INSTANCE = new AbilityCore.Builder<ShiShishiSonsonAbility>("Shi Shishi Sonson", AbilityCategory.STYLE, ShiShishiSonsonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(180.0f), ChargeComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(30.0f), RangeComponent.getTooltip(30.0f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).setUnlockCheck(ShiShishiSonsonAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuousEvent).addEndEvent(this::endContinuityEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);

    public ShiShishiSonsonAbility(AbilityCore<ShiShishiSonsonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging() && entity.field_70170_p.func_175623_d(entity.func_233580_cy_().func_177977_b())) {
            this.continuousComponent.startContinuity(entity, 40.0f);
        } else if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.ITTORYU_CHARGE);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        BlockPos blockpos = WyHelper.rayTraceBlockSafe(entity, 30.0f);
        AbilityDamageSource source = (AbilityDamageSource)((Object)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash());
        Vector3d startPos = entity.func_213303_ch();
        float actualTeleportDistance = 30.0f;
        for (double f = 0.0; f < 1.0; f += 0.13) {
            double z;
            double y;
            double x = MathHelper.func_219803_d((double)f, (double)startPos.func_82615_a(), (double)blockpos.func_177958_n());
            Vector3d pos = new Vector3d(x, y = MathHelper.func_219803_d((double)f, (double)startPos.func_82617_b(), (double)blockpos.func_177956_o()), z = MathHelper.func_219803_d((double)f, (double)startPos.func_82616_c(), (double)blockpos.func_177952_p()));
            List projectiles = WyHelper.getNearbyEntities(pos, (IWorld)entity.field_70170_p, (double)entity.func_213311_cf(), entity.func_213302_cg(), entity.func_213311_cf(), null, ProjectileEntity.class);
            if (projectiles.isEmpty()) continue;
            projectiles.sort(TargetHelper.closestComparator(startPos));
            actualTeleportDistance = MathHelper.func_76133_a((double)((ProjectileEntity)projectiles.get(0)).func_195048_a(startPos));
            break;
        }
        blockpos = WyHelper.rayTraceBlockSafe(entity, actualTeleportDistance);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, actualTeleportDistance, 2.5f);
        for (LivingEntity target : targets) {
            boolean flag;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !(flag = this.dealDamageComponent.hurtTarget(entity, target, 30.0f, source)) || entity.field_70170_p.field_72995_K) continue;
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
        }
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private void duringContinuousEvent(LivingEntity entity, IAbility ability) {
        AbilityDamageSource source = (AbilityDamageSource)((Object)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 2.5f);
        for (LivingEntity target : targets) {
            boolean flag;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !(flag = this.dealDamageComponent.hurtTarget(entity, target, 30.0f, source))) continue;
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isSwordsman() && questProps.hasFinishedQuest(ModQuests.SWORDSMAN_TRIAL_01);
    }
}

