/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TenseiNoSoenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tensei_no_soen", new Pair[]{ImmutablePair.of((Object)"While in the air, the user amasses spiraling flames, then slams into the ground, releasing a massive shockwave.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 600;
    private static final int RANGE = 30;
    private static final int DAMAGE = 50;
    public static final AbilityCore<TenseiNoSoenAbility> INSTANCE = new AbilityCore.Builder<TenseiNoSoenAbility>("Tensei no Soen", AbilityCategory.DEVIL_FRUITS, TenseiNoSoenAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ChargeComponent.getTooltip(60.0f), RangeComponent.getTooltip(30.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(50.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PHOENIX_FLY.get(), new MorphInfo[0]);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private Interval particleInterval = new Interval(2);

    public TenseiNoSoenAbility(AbilityCore<TenseiNoSoenAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.requireMorphComponent, this.chargeComponent, this.rangeComponent, this.dealDamageComponent, this.continuousComponent);
        this.addCanUseCheck(AbilityHelper::requiresInAir);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.TENSEI_NO_SOEN_1.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_233570_aj_()) {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, -10.0, entity.func_213322_ci().field_72449_c);
            entity.field_70133_I = true;
            entity.field_70143_R = 0.0f;
        } else if (entity.func_233570_aj_() || DevilFruitHelper.getDifferenceToFloor((Entity)entity) < 2.0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.TENSEI_NO_SOEN_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 30.0f);
        for (LivingEntity target : targets) {
            this.dealDamageComponent.hurtTarget(entity, target, 50.0f);
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }
}

