/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ushibison;

import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KokuteiCrossAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kokutei_cross", new Pair[]{ImmutablePair.of((Object)"The transformed user crosses their hooves to hit the opponent.", null)});
    private static final int COOLDOWN = 140;
    public static final AbilityCore<KokuteiCrossAbility> INSTANCE = new AbilityCore.Builder<KokuteiCrossAbility>("Kokutei Cross", AbilityCategory.DEVIL_FRUITS, KokuteiCrossAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.BISON_HEAVY.get(), new MorphInfo[0]);

    public KokuteiCrossAbility(AbilityCore<KokuteiCrossAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.requireMorphComponent);
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        Vector3d speed = WyHelper.propulsion(entity, 1.5, 1.5);
        target.func_213293_j(speed.field_72450_a, entity.func_213322_ci().func_82617_b(), speed.field_72449_c);
        if (target instanceof PlayerEntity) {
            ((ServerPlayerEntity)target).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)target));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KOKUTEI_CROSS.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public float getPunchDamage() {
        return 20.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 140.0f;
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public boolean isParallel() {
        return true;
    }
}

