/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.wara;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.SoulboundItemHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.StrawDollItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LifeMinusAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "life_minus", new Pair[]{ImmutablePair.of((Object)"Transfers the damage taken to a Straw Doll in your inventory.", null)});
    public static final AbilityCore<LifeMinusAbility> INSTANCE = new AbilityCore.Builder<LifeMinusAbility>("Life Minus", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, LifeMinusAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);

    public LifeMinusAbility(AbilityCore<LifeMinusAbility> ability) {
        super(ability);
        this.addComponents(this.dealDamageComponent, this.damageTakenComponent);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        boolean canUseDoll;
        if (super.canUse(entity).isFail()) {
            return damage;
        }
        if (!(entity instanceof PlayerEntity)) {
            return damage;
        }
        boolean bl = canUseDoll = !entity.func_70644_a((Effect)ModEffects.ABILITY_OFF.get()) && !AbilityHelper.isWeakenedByKairosekiOrWater(entity);
        if (!canUseDoll) {
            return damage;
        }
        PlayerEntity attacked = (PlayerEntity)entity;
        for (int i = 0; i < attacked.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = attacked.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != ModItems.STRAW_DOLL.get()) continue;
            Pair<UUID, LivingEntity> strawDollOwner = SoulboundItemHelper.getOwner(attacked.field_70170_p, stack);
            StrawDollItem.alterStrawDollHealth(stack, -damage);
            if (attacked == strawDollOwner.getValue()) {
                return damage;
            }
            if (strawDollOwner.getValue() == null) continue;
            ModDamageSource modSource = (ModDamageSource)ModDamageSource.causeAbilityDamage(entity, super.getCore()).setInternal().setBypassFriendlyDamage().func_151518_m();
            boolean attack = this.dealDamageComponent.hurtTarget(entity, (LivingEntity)strawDollOwner.getValue(), damage, modSource);
            if (attack && (((LivingEntity)strawDollOwner.getValue()).func_110143_aJ() <= 0.0f || StrawDollItem.getStrawDollHealth(stack) <= 0.0f)) {
                this.spawnParticles((ServerWorld)attacked.field_70170_p, attacked.func_226277_ct_(), attacked.func_226278_cu_(), attacked.func_226281_cx_());
                this.spawnParticles((ServerWorld)((LivingEntity)strawDollOwner.getValue()).field_70170_p, ((LivingEntity)strawDollOwner.getValue()).func_226277_ct_(), ((LivingEntity)strawDollOwner.getValue()).func_226278_cu_(), ((LivingEntity)strawDollOwner.getValue()).func_226281_cx_());
                IEntityStats ownerProps = EntityStatsCapability.get((LivingEntity)strawDollOwner.getValue());
                ownerProps.setStrawDoll(true);
                attacked.field_71071_by.func_184437_d(stack);
            }
            return 0.0f;
        }
        return damage;
    }

    private void spawnParticles(ServerWorld world, double posX, double posY, double posZ) {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0;
            world.func_195598_a((IParticleData)ParticleTypes.field_197616_i, posX + offsetX, posY + offsetY, posZ + offsetZ, 25, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

