/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.wara;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.StrawDollItem;

public class StrawManAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "straw_man", new Pair[]{ImmutablePair.of((Object)"Creates a doll that representing the entity you attacked, any damage will get redirected to it.", null)});
    private static final int COOLDOWN = 600;
    public static final AbilityCore<StrawManAbility> INSTANCE = new AbilityCore.Builder<StrawManAbility>("Straw Man", AbilityCategory.DEVIL_FRUITS, StrawManAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();

    public StrawManAbility(AbilityCore<StrawManAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.hitTriggerComponent.setBypassSameGroupProtection();
    }

    @Override
    public float getPunchDamage() {
        return 1.0f;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        if (this.canActivate().test(entity) && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            source.setBypassFriendlyDamage();
            IEntityStats targetProps = EntityStatsCapability.get(target);
            int dolls = player.field_71071_by.func_213901_a((Item)ModItems.STRAW_DOLL.get());
            if (dolls < 10) {
                if (AbilityHelper.isTargetBlocking((LivingEntity)player, target) || AbilityHelper.isHakiBlocking((LivingEntity)player, target)) {
                    return;
                }
                if (targetProps.hasStrawDoll()) {
                    ItemStack doll = new ItemStack((IItemProvider)ModItems.STRAW_DOLL.get());
                    StrawDollItem.setStrawDollOwner(doll, target);
                    StrawDollItem.setStrawDollHealth(doll, target.func_110143_aJ());
                    TranslationTextComponent dollName = new TranslationTextComponent(ModI18n.ITEM_STRAW_DOLL, new Object[]{target.func_145748_c_().getString()});
                    doll.func_200302_a((ITextComponent)dollName);
                    player.field_71071_by.func_70441_a(doll);
                    targetProps.setStrawDoll(false);
                }
            }
            this.continuousComponent.stopContinuity((LivingEntity)player);
        }
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 600.0f;
    }
}

