/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.yami.AbsorbedBlocksAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.DarknessBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackHoleAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "black_hole", new Pair[]{ImmutablePair.of((Object)"The user spreads darkness over the target area, which engulfs and suffocates anyone and anything inside of it.", null)});
    private static final int CHARGE_TIME = 100;
    private static final int MAX_COOLDOWN = 400;
    private static final float MIN_COOLDOWN = 200.0f;
    private static final int RANGE = 32;
    public static final AbilityCore<BlackHoleAbility> INSTANCE = new AbilityCore.Builder<BlackHoleAbility>("Black Hole", AbilityCategory.DEVIL_FRUITS, BlackHoleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 400.0f), ChargeComponent.getTooltip(100.0f), ContinuousComponent.getTooltip(), RangeComponent.getTooltip(32.0f, RangeComponent.RangeType.AOE)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private List<LivingEntity> targets = new ArrayList<LivingEntity>();
    private final BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private int amountToFix = 0;
    private double timeToFix = 0.0;
    private State state = State.ABSORBING;

    public BlackHoleAbility(AbilityCore<BlackHoleAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.continuousComponent, this.animationComponent, this.rangeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.state == State.ABSORBING) {
            if (!this.chargeComponent.isCharging()) {
                this.chargeComponent.startCharging(entity, 100.0f);
            } else if (this.chargeComponent.getChargePercentage() >= 0.2f) {
                this.chargeComponent.stopCharging(entity);
            }
        } else if (this.state == State.RELEASING && this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.state == State.ABSORBING) {
            this.blockPlacingHelper.clearList();
            float spread = 0.65f;
            BlockPos.Mutable mutpos = new BlockPos.Mutable();
            for (int i = -32; i < 32; ++i) {
                for (int j = -6; j < 3; ++j) {
                    for (int k = -32; k < 32; ++k) {
                        double posZ;
                        double posY;
                        double posX = entity.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange((int)(32.0f * spread), (int)(32.0f * (spread + 0.35f))) || (double)i > WyHelper.randomWithRange((int)(32.0f * spread), (int)(32.0f * (spread + 0.35f))) ? WyHelper.randomWithRange(-2, 2) : 0.0);
                        if (!AbilityHelper.canPlaceBlock(entity.field_70170_p, posX, posY = entity.func_226278_cu_() + (double)j, posZ = entity.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange((int)(32.0f * spread), (int)(32.0f * (spread + 0.35f))) || (double)k > WyHelper.randomWithRange((int)(32.0f * spread), (int)(32.0f * (spread + 0.35f))) ? WyHelper.randomWithRange(-2, 2) : 0.0), ((Block)ModBlocks.DARKNESS.get()).func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                        mutpos.func_189532_c(posX, posY, posZ);
                        this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, i * i + j * j + k * k);
                    }
                }
            }
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        AbsorbedBlocksAbility absorbedBlocksAbility = abilityDataProps.getPassiveAbility(AbsorbedBlocksAbility.INSTANCE);
        if (this.state == State.ABSORBING) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
            Set<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
            int finished = blockList.size() / 100;
            int i = 0;
            Iterator<BlockPos> iterator = blockList.iterator();
            while (iterator.hasNext()) {
                BlockPos blockPos = iterator.next();
                if (finished-- >= 0) {
                    BlockState oldState = entity.field_70170_p.func_180495_p(blockPos);
                    if (AbilityHelper.placeBlockIfAllowed(entity, blockPos, ((Block)ModBlocks.DARKNESS.get()).func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE)) {
                        absorbedBlocksAbility.addAbsorbedBlock(oldState, blockPos);
                    }
                    if (!entity.field_70170_p.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76218_k()) {
                        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLACK_HOLE.get(), (Entity)entity, blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 0.5, blockPos.func_177952_p());
                    }
                    List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, blockPos, 1.5f);
                    for (LivingEntity target : targets) {
                        if (this.targets.contains(target) || target.func_110124_au() == entity.func_110124_au()) continue;
                        this.targets.add(target);
                        EffectInstance instance = new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1);
                        target.func_195064_c(instance);
                        ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
                        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLACK_HOLE.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                    }
                    ++i;
                    iterator.remove();
                    continue;
                }
                break;
            }
        } else if (this.state == State.RELEASING) {
            List<AbsorbedBlocksAbility.BlockData> uncompressedBlocks = absorbedBlocksAbility.getUncompressedBlocks();
            double batchSize = Math.ceil((double)this.amountToFix / this.timeToFix);
            int index = uncompressedBlocks.size();
            int i = 0;
            while (--index >= 0) {
                BlockState blockState;
                double d = batchSize;
                batchSize = d - 1.0;
                if (!(d > 0.0)) break;
                AbsorbedBlocksAbility.BlockData blockData = uncompressedBlocks.get(index);
                BlockPos blockPos = blockData.getBlockPos();
                if (AbilityHelper.placeBlockIfAllowed(entity, blockPos, blockState = blockData.getBlockState(), 3, DarknessBlockProtectionRule.INSTANCE)) {
                    if (!entity.field_70170_p.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76218_k()) {
                        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BLACK_HOLE.get(), (Entity)entity, blockPos.func_177958_n(), (float)blockPos.func_177956_o() + 0.5f, blockPos.func_177952_p());
                    }
                    absorbedBlocksAbility.removeAbsorbedBlock(blockData);
                }
                ++i;
            }
            if (uncompressedBlocks.isEmpty()) {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.state == State.ABSORBING) {
            this.targets.clear();
            this.timeToFix = this.chargeComponent.getChargeTime();
            IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
            AbsorbedBlocksAbility absorbedBlocksAbility = abilityDataProps.getPassiveAbility(AbsorbedBlocksAbility.INSTANCE);
            this.amountToFix = absorbedBlocksAbility.getUncompressedBlocks().size();
            this.state = State.RELEASING;
            this.continuousComponent.startContinuity(entity, -1.0f);
        } else if (this.state == State.RELEASING) {
            this.state = State.ABSORBING;
            this.cooldownComponent.startCooldown(entity, (float)(400.0 * Math.max(0.5, (double)this.chargeComponent.getChargePercentage())));
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        AbsorbedBlocksAbility absorbedBlocksAbility = abilityDataProps.getPassiveAbility(AbsorbedBlocksAbility.INSTANCE);
        if (absorbedBlocksAbility.getUncompressedBlocks().isEmpty()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.chargeComponent.startCharging(entity, (int)this.timeToFix);
    }

    private static enum State {
        ABSORBING,
        RELEASING;

    }
}

