/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.BlackRoadProjectile;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackRoadAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "black_road", new Pair[]{ImmutablePair.of((Object)"The user spreads darkness in a forward path.", null)});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 120;
    private static final int RANGE = 24;
    public static final AbilityCore<BlackRoadAbility> INSTANCE = new AbilityCore.Builder<BlackRoadAbility>("Black Road", AbilityCategory.DEVIL_FRUITS, BlackRoadAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ChargeComponent.getTooltip(120.0f), RangeComponent.getTooltip(24.0f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.GRAVITY).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.2).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private Interval particleInterval = new Interval(2);

    public BlackRoadAbility(AbilityCore<BlackRoadAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 120.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DARK_MATTER_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 1.1f, 1.0f);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DARK_MATTER_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private BlackRoadProjectile createProjectile(LivingEntity entity) {
        int range = (int)(24.0f * this.chargeComponent.getChargePercentage());
        BlackRoadProjectile proj = new BlackRoadProjectile(entity.field_70170_p, entity, this);
        proj.setLife(range);
        return proj;
    }
}

