/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.DarkMatterProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DarkMatterAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "dark_matter", new Pair[]{ImmutablePair.of((Object)"Launches a ball of darkness that engulfs the opponent.", null)});
    private static final int COOLDOWN = 280;
    private static final int CHARGE_TIME = 80;
    public static final AbilityCore<DarkMatterAbility> INSTANCE = new AbilityCore.Builder<DarkMatterAbility>("Dark Matter", AbilityCategory.DEVIL_FRUITS, DarkMatterAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(280.0f), ChargeComponent.getTooltip(80.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.GRAVITY).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private DarkMatterProjectile proj = null;
    private Interval particleInterval = new Interval(2);

    public DarkMatterAbility(AbilityCore<DarkMatterAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 80.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.proj = null;
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.proj == null) {
            this.proj = (DarkMatterProjectile)((Object)this.projectileComponent.getNewProjectile(entity));
            entity.field_70170_p.func_217376_c((Entity)this.proj);
        } else {
            this.proj.setLife(this.proj.getMaxLife());
            this.proj.func_70107_b(entity.func_226277_ct_(), entity.func_226280_cw_() + 3.0, entity.func_226281_cx_());
        }
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DARK_MATTER_CHARGING.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.proj.func_234612_a_((Entity)entity, entity.field_70125_A + 10.0f, entity.field_70177_z, 0.0f, 3.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 280.0f);
    }

    private DarkMatterProjectile createProjectile(LivingEntity entity) {
        DarkMatterProjectile proj = new DarkMatterProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

