/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KurouzuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kurouzu", new Pair[]{ImmutablePair.of((Object)"Creates a strong gravitational force, that pulls the opponent towards the user.", null)});
    private static final float DAMAGE_THRESHOLD = 10.0f;
    private static final float COOLDOWN = 240.0f;
    private static final float DAMAGE = 30.0f;
    private static final float CHARGE_TIME = 20.0f;
    public static final AbilityCore<KurouzuAbility> INSTANCE = new AbilityCore.Builder<KurouzuAbility>("Kurouzu", AbilityCategory.DEVIL_FRUITS, KurouzuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(20.0f), DealDamageComponent.getTooltip(30.0f)).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.DAMAGE);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private Interval particleInterval = new Interval(5);
    private LivingEntity grabbedEntity = null;
    private float damageTaken = 0.0f;

    public KurouzuAbility(AbilityCore<KurouzuAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.chargeComponent, this.dealDamageComponent, this.damageTakenComponent, this.animationComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.grabbedEntity = null;
            this.damageTaken = 0.0f;
            this.animationComponent.start(entity, ModAnimations.POINT_LEFT_ARM);
            this.continuousComponent.triggerContinuity(entity, WyHelper.secondsToTicks(10.0f));
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 128.0);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b - (mop instanceof EntityRayTraceResult ? 1.0 : 0.0);
        double k = mop.func_216347_e().field_72449_c;
        boolean canTick = this.particleInterval.canTick();
        if (canTick) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KUROUZU.get(), (Entity)entity, i, j, k);
            Vector3d lookVec = entity.func_70040_Z();
            Vector3d particlePos = entity.func_213303_ch().func_72441_c(lookVec.field_72450_a, lookVec.field_72448_b + 1.5, lookVec.field_72449_c);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KUROUZU_CHARGING.get(), (Entity)entity, particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c());
        }
        if (mop.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        List<LivingEntity> targets = WyHelper.getNearbyLiving(new Vector3d(i, j, k), (IWorld)entity.field_70170_p, 5.0, ModEntityPredicates.getEnemyFactions(entity));
        for (LivingEntity target : targets) {
            Vector3d dirVec = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b();
            target.func_213293_j(-dirVec.field_72450_a, -dirVec.field_72448_b, -dirVec.field_72449_c);
            target.field_70133_I = true;
            if (!canTick) continue;
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 5));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 5));
            this.grabbedEntity = AbilityHelper.canGrab(entity, false);
            if (this.grabbedEntity == null) continue;
            this.chargeComponent.startCharging(entity, 20.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabbedEntity == null) {
            this.animationComponent.stop(entity);
            this.cooldownComponent.startCooldown(entity, 240.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.continuousComponent.stopContinuity(entity);
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_76419_f, 100, 5));
        if (this.grabbedEntity instanceof PlayerEntity) {
            AbilityHelper.disableAbilities(this.grabbedEntity, 20, abl -> abl.getCore().getCategory() == AbilityCategory.DEVIL_FRUITS);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabbedEntity == null || !this.grabbedEntity.func_70089_S()) {
            this.chargeComponent.stopCharging(entity);
            return;
        }
        float distance = 1.0f;
        Vector3d lookVec = entity.func_70040_Z().func_72441_c(0.2, 0.0, 0.2);
        Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * (double)distance, entity.func_226278_cu_(), entity.func_226281_cx_() + lookVec.field_72449_c * (double)distance);
        this.grabbedEntity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.grabbedEntity != null && this.dealDamageComponent.hurtTarget(entity, this.grabbedEntity, 30.0f)) {
            Vector3d dir = entity.func_70040_Z().func_216372_d(3.0, 0.0, 3.0);
            this.grabbedEntity.func_213317_d(this.grabbedEntity.func_213322_ci().func_72441_c(dir.field_72450_a, 0.2, dir.field_72449_c));
            this.grabbedEntity.field_70133_I = true;
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private float onDamageTaken(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.continuousComponent.isContinuous() || this.chargeComponent.isCharging()) {
            return damage;
        }
        this.damageTaken += damage;
        if (this.damageTaken >= 10.0f) {
            this.continuousComponent.stopContinuity(user);
        }
        return damage;
    }
}

