/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.yami.AbsorbedBlocksAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.LiberationProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class LiberationAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "liberation", new Pair[]{ImmutablePair.of((Object)"The user sucks up any Darkness they've placed.", null), ImmutablePair.of((Object)"The user releases all the Darkness stored at the location they're looking at.", null)});
    private static final TranslationTextComponent LIBERATION_ABSORPB_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.liberation", "Liberation"));
    private static final TranslationTextComponent LIBERATION_RELEASE_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.liberation_release", "Liberation: Release"));
    private static final ResourceLocation LIBERATION_ABSORB_ICON = new ResourceLocation("mineminenomi", "textures/abilities/liberation.png");
    private static final ResourceLocation LIBERATION_RELEASE_ICON = new ResourceLocation("mineminenomi", "textures/abilities/liberation_release.png");
    private static final float COOLDOWN = 80.0f;
    public static final AbilityCore<LiberationAbility> INSTANCE = new AbilityCore.Builder<LiberationAbility>("Liberation", AbilityCategory.DEVIL_FRUITS, LiberationAbility::new).addAdvancedDescriptionLine(CooldownComponent.getTooltip(80.0f)).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> LIBERATION_ABSORPB_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0]).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> LIBERATION_RELEASE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1]).build();
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.ABSORB).addChangeModeEvent(this::onAltModeChange);
    private static final int BATCH_SIZE = 256;

    public LiberationAbility(AbilityCore<LiberationAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.altModeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        AbsorbedBlocksAbility absorbedBlocksAbility = abilityDataProps.getPassiveAbility(AbsorbedBlocksAbility.INSTANCE);
        if (absorbedBlocksAbility == null) {
            return;
        }
        if (this.altModeComponent.getCurrentMode() == Mode.ABSORB) {
            List<BlockPos> blockPositions = WyHelper.getNearbyBlocks(entity.func_233580_cy_(), (IWorld)entity.field_70170_p, 40, 40, 40, blockState -> blockState.func_177230_c() == ModBlocks.DARKNESS.get());
            for (BlockPos blockPos : blockPositions) {
                for (AbsorbedBlocksAbility.BlockData blockData : absorbedBlocksAbility.getAbsorbedBlocks()) {
                    if (!blockData.getBlockPos().equals((Object)blockPos)) continue;
                    blockData.setCompressed(true);
                }
                entity.field_70170_p.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.RELEASE) {
            int batchSize = Math.min(256, absorbedBlocksAbility.getCompressedBlocks().size());
            for (int i = 0; i < batchSize; ++i) {
                AbsorbedBlocksAbility.BlockData blockData = absorbedBlocksAbility.getCompressedBlocks().get(this.random.nextInt(absorbedBlocksAbility.getCompressedBlocks().size()));
                LiberationProjectile proj = new LiberationProjectile(entity.field_70170_p, entity, blockData.getBlockState().func_177230_c(), (Ability)this);
                Vector3d lookVec = entity.func_70040_Z().func_72432_b();
                RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
                double x = mop.func_216347_e().field_72450_a;
                double y = mop.func_216347_e().field_72448_b;
                double z = mop.func_216347_e().field_72449_c;
                if (lookVec.field_72448_b > 0.7) {
                    proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.0f, 6.0f);
                    proj.setMaxLife(300);
                    proj.setGravity(0.05f);
                } else {
                    proj.func_70012_b(x + WyHelper.randomWithRange(-3, 3), y + 14.0 + WyHelper.randomWithRange(0, 4), z + WyHelper.randomWithRange(-3, 3), 0.0f, 0.0f);
                    proj.func_213293_j(0.0, -0.7 - entity.field_70170_p.field_73012_v.nextDouble(), 0.0);
                }
                entity.field_70170_p.func_217376_c((Entity)proj);
                absorbedBlocksAbility.removeAbsorbedBlock(blockData);
            }
        }
        this.cooldownComponent.startCooldown(entity, 80.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.ABSORB) {
            super.setDisplayIcon(LIBERATION_ABSORB_ICON);
        } else if (mode == Mode.RELEASE) {
            super.setDisplayIcon(LIBERATION_RELEASE_ICON);
        }
    }

    public static enum Mode {
        ABSORB,
        RELEASE;

    }
}

