/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yomi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KasuriutaFubukiGiriAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kasuriuta_fubuki_giri", new Pair[]{ImmutablePair.of((Object)"A quick slash at the enemy that also freezes them.", null)});
    private static final float MAX_TELEPORT_DISTANCE = 30.0f;
    private static final int COOLDOWN = 160;
    private static final int CHARGE_TIME = 20;
    private static final int RANGE = 3;
    private static final int DAMAGE = 20;
    public static final AbilityCore<KasuriutaFubukiGiriAbility> INSTANCE = new AbilityCore.Builder<KasuriutaFubukiGiriAbility>("Kasuriuta: Fubuki Giri", AbilityCategory.DEVIL_FRUITS, KasuriutaFubukiGiriAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), ChargeComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).setSourceElement(SourceElement.ICE).setUnlockCheck(KasuriutaFubukiGiriAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargingEvent).addTickEvent(this::duringChargingEvent).addEndEvent(this::endChargingEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public KasuriutaFubukiGiriAbility(AbilityCore<KasuriutaFubukiGiriAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.hitTrackerComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 20.0f);
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.ITTORYU_CHARGE);
    }

    private void duringChargingEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        AbilityHelper.slowEntityFall(entity, 15);
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        BlockPos blockpos = WyHelper.rayTraceBlockSafe(entity, 30.0f);
        AbilityDamageSource source = (AbilityDamageSource)((Object)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setSlash());
        Vector3d startPos = entity.func_213303_ch();
        float actualTeleportDistance = 30.0f;
        for (double f = 0.0; f < 1.0; f += 0.13) {
            double x = MathHelper.func_219803_d((double)f, (double)startPos.func_82615_a(), (double)blockpos.func_177958_n());
            double y = MathHelper.func_219803_d((double)f, (double)startPos.func_82617_b(), (double)blockpos.func_177956_o());
            double z = MathHelper.func_219803_d((double)f, (double)startPos.func_82616_c(), (double)blockpos.func_177952_p());
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KASURIUTA_FUBUKI_GIRI.get(), (Entity)entity, x, y - 1.0, z);
            Vector3d pos = new Vector3d(x, y, z);
            List projectiles = WyHelper.getNearbyEntities(pos, (IWorld)entity.field_70170_p, (double)entity.func_213311_cf(), entity.func_213302_cg(), entity.func_213311_cf(), null, ProjectileEntity.class);
            if (projectiles.isEmpty()) continue;
            projectiles.sort(TargetHelper.closestComparator(startPos));
            actualTeleportDistance = MathHelper.func_76133_a((double)((ProjectileEntity)projectiles.get(0)).func_195048_a(startPos));
            break;
        }
        blockpos = WyHelper.rayTraceBlockSafe(entity, actualTeleportDistance);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, actualTeleportDistance, 3.0f);
        for (LivingEntity target : targets) {
            boolean flag;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !(flag = this.dealDamageComponent.hurtTarget(entity, target, 20.0f, source))) continue;
            EffectInstance instance = new EffectInstance((Effect)ModEffects.FROZEN.get(), 70, 0);
            target.func_195064_c(instance);
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
        }
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        entity.func_226292_a_(Hand.MAIN_HAND, true);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        return ((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive(entity);
    }
}

