/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yuki;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FubukiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "fubuki", new Pair[]{ImmutablePair.of((Object)"The user releases an extremely cold stream around themselves inflicting %s and causing serious damage to those affected by it.", (Object)new Object[]{ModEffects.FROSTBITE})});
    private static final int COOLDOWN = 200;
    private static final int DAMAGE = 20;
    private static final int RANGE = 25;
    public static final AbilityCore<FubukiAbility> INSTANCE = new AbilityCore.Builder<FubukiAbility>("Fubuki", AbilityCategory.DEVIL_FRUITS, FubukiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), DealDamageComponent.getTooltip(20.0f), RangeComponent.getTooltip(25.0f, RangeComponent.RangeType.AOE)).build();
    private static final BlockProtectionRule.IReplaceBlockRule REPLACE_RULE = (world, pos, state) -> world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150433_aE;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public FubukiAbility(AbilityCore<FubukiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.dealDamageComponent, this.rangeComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        AbilityHelper.createSphere(entity.field_70170_p, entity.func_233580_cy_(), 25, 25, false, Blocks.field_150433_aE, REPLACE_RULE, 3, DefaultProtectionRules.AIR_FOLIAGE);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 25.0f);
        for (LivingEntity target : targets) {
            AbilityHelper.addFrostbiteStacks(target, entity, 5);
            if (!target.func_70644_a((Effect)ModEffects.FROSTBITE.get()) && !target.func_70644_a((Effect)ModEffects.FROZEN.get())) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FUBUKI.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

