/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yuki;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yuki.KamakuraParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KamakuraAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kamakura", new Pair[]{ImmutablePair.of((Object)"Creates an igloo-like snow barrier where the user's pointing.", null), ImmutablePair.of((Object)"If used while crouching it'll create the igloo around the user.", null)});
    private static final int COOLDOWN = 160;
    public static final AbilityCore<KamakuraAbility> INSTANCE = new AbilityCore.Builder<KamakuraAbility>("Kamakura", AbilityCategory.DEVIL_FRUITS, KamakuraAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).addApprovedBlocks(Blocks.field_150433_aE).build();
    private static final KamakuraParticleEffect.Details DETAILS = new KamakuraParticleEffect.Details(4);

    public KamakuraAbility(AbilityCore<KamakuraAbility> core) {
        super(core);
        this.isNew = true;
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        World world = entity.field_70170_p;
        Vector3d vec3d = entity.func_213453_ef() ? entity.func_213303_ch() : WyHelper.rayTraceBlocksAndEntities((Entity)entity, 64.0).func_216347_e();
        AbilityHelper.createEmptySphere(world, (int)vec3d.field_72450_a, (int)vec3d.field_72448_b, (int)vec3d.field_72449_c, 4, (Block)ModBlocks.HARDENED_SNOW.get(), GRIEF_RULE);
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KAMAKURA.get(), (Entity)entity, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, DETAILS);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

