/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yuki;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.WallAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yuki.KamakuraParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YukiGakiAbility
extends WallAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yuki_gaki", new Pair[]{ImmutablePair.of((Object)"Creates a wall made of hardened snow to protect the user.", null)});
    private static final int COOLDOWN = 100;
    public static final AbilityCore<YukiGakiAbility> INSTANCE = new AbilityCore.Builder<YukiGakiAbility>("Yuki Gaki", AbilityCategory.DEVIL_FRUITS, YukiGakiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).build();
    private static final KamakuraParticleEffect.Details DETAILS = new KamakuraParticleEffect.Details(4);

    public YukiGakiAbility(AbilityCore<YukiGakiAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::onUseEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.KAMAKURA.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), DETAILS);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    @Override
    public int getThickness() {
        return 2;
    }

    @Override
    public int getHeight() {
        return 4;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Block getWallBlock() {
        return (Block)ModBlocks.HARDENED_SNOW.get();
    }

    @Override
    public BlockProtectionRule getGriefingRule() {
        return GRIEF_RULE;
    }

    @Override
    public boolean stopAfterUse() {
        return true;
    }
}

