/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zou;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class IvoryDartAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "ivory_dart", new Pair[]{ImmutablePair.of((Object)"Launches the user forward in their elephant form, causing damage and destruction.", null)});
    private static final int COOLDOWN = 280;
    private static final int CONTINUITY = 20;
    private static final float AREA_SIZE = 4.0f;
    private static final float DAMAGE = 20.0f;
    public static final AbilityCore<IvoryDartAbility> INSTANCE = new AbilityCore.Builder<IvoryDartAbility>("Ivory Dart", AbilityCategory.DEVIL_FRUITS, IvoryDartAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(280.0f), ContinuousComponent.getTooltip(20.0f), RangeComponent.getTooltip(4.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(100, this::stopContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.ZOU_GUARD.get(), new MorphInfo[0]);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(20);
    private int initialY;

    public IvoryDartAbility(AbilityCore<IvoryDartAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.requireMorphComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.initialY = (int)entity.func_226278_cu_();
        Vector3d speed = WyHelper.propulsion(entity, 4.0, 4.0);
        entity.func_213293_j(speed.field_72450_a, entity.func_213322_ci().func_82617_b(), speed.field_72449_c);
        ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)entity));
        this.continuousComponent.startContinuity(entity, 20.0f);
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 280.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 4.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
        }
        if (entity.func_226278_cu_() >= (double)this.initialY) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (BlockPos location : WyHelper.getNearbyBlocks((Entity)entity, 4)) {
                if (!((double)location.func_177956_o() >= entity.func_226278_cu_()) || !AbilityHelper.placeBlockIfAllowed(entity, location, Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                positions.add(location);
            }
            if (positions.size() > 0) {
                this.details.setPositions(positions);
                WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
            }
        }
    }
}

