/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zou;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.zou.TrunkShotProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class TrunkShotAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "trunk_shot", new Pair[]{ImmutablePair.of((Object)"Launches the user's trunk at the enemy.", null)});
    private static final int COOLDOWN = 160;
    public static final AbilityCore<TrunkShotAbility> INSTANCE = new AbilityCore.Builder<TrunkShotAbility>("Trunk Shot", AbilityCategory.DEVIL_FRUITS, TrunkShotAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.ZOU_GUARD.get(), (MorphInfo)ModMorphs.ZOU_HEAVY.get());

    public TrunkShotAbility(AbilityCore<TrunkShotAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.requireMorphComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.5f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private TrunkShotProjectile createProjectile(LivingEntity entity) {
        TrunkShotProjectile proj = new TrunkShotProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

