/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.zushi.GraviZoneParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class GraviZoneAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gravi_zone", new Pair[]{ImmutablePair.of((Object)"Creates an area in which entities cannot move.", null), ImmutablePair.of((Object)"Creates an area which pushed away all enemies.", null)});
    private static final TranslationTextComponent GUARD_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gravi_zone", "Gravi Zone: Guard"));
    private static final TranslationTextComponent REJECT_NAME = new TranslationTextComponent(WyRegistry.registerName("ability.mineminenomi.gravi_zone_reject", "Gravi Zone: Reject"));
    private static final ResourceLocation GRAVI_ZONE_GUARD_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gravi_zone.png");
    private static final ResourceLocation GRAVI_ZONE_REJECT_ICON = new ResourceLocation("mineminenomi", "textures/abilities/gravi_zone_reject.png");
    private static final int COOLDOWN = 200;
    private static final int GUARD_HOLD_TIME = 100;
    private static final int REJECT_HOLD_TIME = 160;
    private static final int GUARD_RANGE = 8;
    private static final int REJECT_RANGE = 3;
    private static final int REJECT_DAMAGE = 10;
    public static final AbilityCore<GraviZoneAbility> INSTANCE = new AbilityCore.Builder<GraviZoneAbility>("Gravi Zone", AbilityCategory.DEVIL_FRUITS, GraviZoneAbility::new).addDescriptionLine((e, a) -> GUARD_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[0], CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(100.0f), RangeComponent.getTooltip(8.0f, RangeComponent.RangeType.AOE)).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, (e, a) -> REJECT_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), (e, a) -> DESCRIPTION[1], CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(160.0f), RangeComponent.getTooltip(3.0f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(10.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.GUARD).addChangeModeEvent(this::onAltModeChange);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private Interval gravityRingInterval = new Interval(10);

    public GraviZoneAbility(AbilityCore<GraviZoneAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.altModeComponent, this.rangeComponent, this.dealDamageComponent);
        this.setDisplayName((ITextComponent)GUARD_NAME);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
            this.continuousComponent.triggerContinuity(entity, 100.0f);
        } else if (this.altModeComponent.getCurrentMode() == Mode.REJECT) {
            this.continuousComponent.triggerContinuity(entity, 160.0f);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        boolean spawnGravityRings = this.gravityRingInterval.canTick();
        if (this.altModeComponent.getCurrentMode() == Mode.GUARD) {
            int range = 8;
            List<Entity> list = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, 8.0, ModEntityPredicates.getEnemyFactions(entity), Entity.class);
            list.forEach(target -> {
                target.func_70107_b(target.field_70169_q, target.field_70167_r, target.field_70166_s);
                if (target instanceof LivingEntity) {
                    ((LivingEntity)target).func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 0, false, false));
                }
                target.field_70133_I = true;
            });
            if (spawnGravityRings) {
                GraviZoneAbility.gravityRing(entity, range, 0, true);
                GraviZoneAbility.gravityRing(entity, range - 2, 4, true);
                GraviZoneAbility.gravityRing(entity, range - 4, 8, true);
            }
        } else if (this.altModeComponent.getCurrentMode() == Mode.REJECT) {
            int range = 3;
            List<Entity> list = WyHelper.getNearbyEntities(entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, ModEntityPredicates.getEnemyFactions(entity), Entity.class);
            list.forEach(target -> {
                boolean causedDamage = true;
                if (target instanceof LivingEntity) {
                    causedDamage = this.dealDamageComponent.hurtTarget(entity, (LivingEntity)target, 10.0f);
                }
                if (causedDamage) {
                    Vector3d dist = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0).func_72432_b();
                    double power = 4.5;
                    double xSpeed = -dist.field_72450_a * power;
                    double zSpeed = -dist.field_72449_c * power;
                    target.func_213293_j(-xSpeed, (double)0.2f, -zSpeed);
                    target.field_70133_I = true;
                }
            });
            if (spawnGravityRings) {
                GraviZoneAbility.gravityRing(entity, range + 3, 4, true);
                GraviZoneAbility.gravityRing(entity, range + 2, 2, true);
                GraviZoneAbility.gravityRing(entity, range, 0, true);
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.GUARD) {
            this.setDisplayName((ITextComponent)GUARD_NAME);
            super.setDisplayIcon(GRAVI_ZONE_GUARD_ICON);
        } else if (mode == Mode.REJECT) {
            this.setDisplayName((ITextComponent)REJECT_NAME);
            super.setDisplayIcon(GRAVI_ZONE_REJECT_ICON);
        }
    }

    public static void gravityRing(LivingEntity entity, int range, int yOffset, boolean visibleOnlyFromOwner) {
        GraviZoneParticleEffect.Details details = new GraviZoneParticleEffect.Details();
        details.setRange(range);
        details.setYOffset(yOffset);
        if (visibleOnlyFromOwner && entity instanceof PlayerEntity) {
            WyHelper.spawnParticleEffectForOwner((ParticleEffect)ModParticleEffects.GRAVI_ZONE.get(), (PlayerEntity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), details);
        } else {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GRAVI_ZONE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), details);
        }
    }

    public static enum Mode {
        GUARD,
        REJECT;

    }
}

