/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.animations.mandemontactics;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;
import xyz.pixelatedw.mineminenomi.api.animations.Animation;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;

public class DemonicDanceLeapAnimation
extends Animation<LivingEntity, BipedModel<LivingEntity>> {
    public DemonicDanceLeapAnimation(AnimationId<DemonicDanceLeapAnimation> animId) {
        super(animId);
        this.setAnimationSetup(this::setup);
        this.setAnimationAngles(this::angles);
        this.setAnimationHeldItem(this::heldItem);
    }

    public void setup(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float rotationYaw, float partialTicks) {
        if (!this.isInAir(entity)) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        }
    }

    public void angles(LivingEntity entity, BipedModel<LivingEntity> model, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.isInAir(entity)) {
            model.field_178723_h.field_78795_f = (float)Math.toRadians(180.0);
            model.field_178723_h.field_78808_h = (float)Math.toRadians(-10.0);
            model.field_178721_j.field_78795_f = 1.2f;
            model.field_178721_j.field_78796_g = -0.1f;
            model.field_178721_j.field_78798_e = -1.0f;
            model.field_178722_k.field_78795_f = 1.2f;
            model.field_178722_k.field_78796_g = 0.1f;
            model.field_178722_k.field_78798_e = -1.0f;
        } else {
            model.field_178723_h.field_78795_f = (float)Math.toRadians(-90.0);
            model.field_178721_j.field_78795_f = -1.2f;
            model.field_178721_j.field_78796_g = 0.3f;
            model.field_178721_j.field_78798_e = 1.0f;
            model.field_178722_k.field_78795_f = 1.2f;
            model.field_178722_k.field_78796_g = 0.1f;
            model.field_178722_k.field_78798_e = -1.0f;
        }
    }

    public void heldItem(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide handSide, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int packedLight) {
        if (handSide == HandSide.RIGHT) {
            matrixStack.func_227861_a_(0.0, 0.0, 0.15);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        }
    }

    private boolean isInAir(LivingEntity entity) {
        double groundDistance = DevilFruitHelper.getDifferenceToFloor((Entity)entity);
        return this.getTime() <= 5L || groundDistance > (double)0.8f;
    }
}

