/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import java.awt.Color;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class DFEncyclopediaEntry {
    private final Optional<Color> baseColor;
    private final Optional<Color> stemColor;
    private final Optional<Integer> shape;
    private AkumaNoMiItem devilFruit;

    public static DFEncyclopediaEntry empty() {
        return new DFEncyclopediaEntry(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static DFEncyclopediaEntry of(Optional<Integer> type, Optional<Color> baseColor, Optional<Color> stemColor) {
        return new DFEncyclopediaEntry(type, baseColor, stemColor);
    }

    public static DFEncyclopediaEntry of(CompoundNBT nbt) {
        Optional<Integer> shape = Optional.empty();
        int shapeVal = nbt.func_74762_e("shape");
        if (shapeVal > 0) {
            shape = Optional.of(shapeVal);
        }
        Color baseVal = new Color(nbt.func_74762_e("baseColor"));
        Color stemVal = new Color(nbt.func_74762_e("stemColor"));
        return new DFEncyclopediaEntry(shape, Optional.of(baseVal), Optional.of(stemVal));
    }

    public DFEncyclopediaEntry(Optional<Integer> shape, Optional<Color> baseColor, Optional<Color> stemColor) {
        this.shape = shape;
        this.baseColor = baseColor;
        this.stemColor = stemColor;
    }

    public Optional<Color> getBaseColor() {
        return this.baseColor;
    }

    public Optional<Color> getStemColor() {
        return this.stemColor;
    }

    public Optional<Integer> getShape() {
        return this.shape;
    }

    public AkumaNoMiItem getDevilFruit() {
        return this.devilFruit;
    }

    public void setDevilFruit(AkumaNoMiItem devilFruit) {
        this.devilFruit = devilFruit;
    }

    public int getCompletion() {
        int sum = 0;
        if (this.getShape().isPresent()) {
            ++sum;
        }
        if (this.getBaseColor().isPresent() && this.getBaseColor().get().getRGB() != Color.BLACK.getRGB()) {
            ++sum;
        }
        if (this.getStemColor().isPresent() && this.getStemColor().get().getRGB() != Color.BLACK.getRGB()) {
            ++sum;
        }
        return sum;
    }

    public boolean isComplete() {
        return this.getCompletion() >= 3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        if (this.getShape().isPresent()) {
            sb.append("Shape: " + this.getShape().get() + " ");
        }
        if (this.getBaseColor().isPresent()) {
            sb.append("Base Color: " + this.getBaseColor().get().toString() + " ");
        }
        if (this.getStemColor().isPresent()) {
            sb.append("Stem Color: " + this.getStemColor().get().toString() + " ");
        }
        sb.append("Completion: " + this.getCompletion());
        sb.append(" ]");
        return sb.toString();
    }
}

