/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IExtraUpdateData;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimeScreamComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SlotDecorationComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityTickEvent;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.commands.FGCommand;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDCapability;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;

public abstract class Ability
implements IAbility {
    private ITextComponent displayName;
    private ResourceLocation displayIcon;
    private ResourceLocation cachedIcon;
    @Deprecated
    protected double cooldown;
    @Deprecated
    protected double maxCooldown;
    @Deprecated
    protected double disableTicks;
    @Deprecated
    protected double maxDisableTicks = 200.0;
    private AbilityUnlock unlock = AbilityUnlock.PROGRESSION;
    private State state = State.STANDBY;
    private State previousState = State.STANDBY;
    @Deprecated
    private boolean forcedState = false;
    @Deprecated
    private boolean needsClientSide = false;
    @Deprecated
    private int[] pools = new int[0];
    @Deprecated
    protected double timeProgression = 1.0;
    private final AbilityCore<? extends IAbility> core;
    private long lastUseTime;
    @Deprecated
    public boolean isNew = false;
    private boolean isOGCD;
    protected final DisableComponent disableComponent = new DisableComponent(this);
    protected final CooldownComponent cooldownComponent = new CooldownComponent(this);
    protected final AnimeScreamComponent screamComponent = new AnimeScreamComponent(this);
    private Map<AbilityComponentKey<?>, AbilityComponent<?>> components = new LinkedHashMap();
    protected final Random random = new Random();
    @Deprecated
    protected IOnUse onUseEvent = player -> true;
    @Deprecated
    protected IDuringCooldown duringCooldownEvent = (player, cooldown) -> {};
    @Deprecated
    protected IOnEndCooldown onEndCooldownEvent = player -> {};
    private List<ICanUseEvent> onCanUseEvents = new ArrayList<ICanUseEvent>();
    private final PriorityEventPool<IOnUse2Event> onUseEvents = new PriorityEventPool();
    private List<IOnTickEvent> onTickEvents = new ArrayList<IOnTickEvent>();
    private List<IOnEquipEvent> onEquipEvents = new ArrayList<IOnEquipEvent>();
    private List<IOnRemoveEvent> onRemoveEvents = new ArrayList<IOnRemoveEvent>();

    public Ability(AbilityCore<? extends IAbility> core) {
        this.core = core;
        if (this.isClientSide()) {
            SlotDecorationComponent slotDecorationComponent = new SlotDecorationComponent(this);
            this.addComponents(slotDecorationComponent);
        }
        this.addComponents(this.cooldownComponent, this.disableComponent, this.screamComponent);
    }

    @Deprecated
    public void use(PlayerEntity player) {
        if (this.isNew) {
            this.use((LivingEntity)player);
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (!this.isOnStandby()) {
            return;
        }
        AbilityUseEvent.Pre pre = new AbilityUseEvent.Pre((LivingEntity)player, this);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            return;
        }
        if (!this.isStateForced() && this.onUseEvent.onUse(player)) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            this.checkAbilityPool(player, State.COOLDOWN);
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue()) {
                WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getDisplayNameOld()), (LivingEntity)player);
            }
            AbilityUseEvent.Post post = new AbilityUseEvent.Post((LivingEntity)player, this);
            MinecraftForge.EVENT_BUS.post((Event)post);
            this.startCooldown(player);
            props.setPreviouslyUsedAbility(this);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (LivingEntity)player);
        }
    }

    @Override
    public final void use(LivingEntity entity) {
        AbilityUseResult result = this.canUse(entity);
        if (result.isFail()) {
            if (result.getMessage() != null) {
                entity.func_145747_a(result.getMessage(), Util.field_240973_b_);
            }
            return;
        }
        AbilityUseEvent.Pre pre = new AbilityUseEvent.Pre(entity, this);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            return;
        }
        this.onUseEvents.dispatch(event -> event.onUse(entity, this));
        this.lastUseTime = entity.field_70170_p.func_82737_E();
        IAbilityData props = AbilityDataCapability.get(entity);
        AbilityUseEvent.Post post = new AbilityUseEvent.Post(entity, this);
        MinecraftForge.EVENT_BUS.post((Event)post);
        props.setPreviouslyUsedAbility(this);
    }

    @Override
    public void onEquip(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        this.onEquipEvents.forEach(event -> event.onEquip(entity, this));
    }

    @Override
    public void onRemove(LivingEntity entity) {
        this.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity(entity));
        this.getComponent(ModAbilityKeys.MORPH).ifPresent(comp -> comp.stopMorph(entity));
        this.getComponent(ModAbilityKeys.CHANGE_STATS).ifPresent(comp -> comp.removeModifiers(entity));
        this.onRemoveEvents.forEach(event -> event.onRemove(entity, this));
    }

    public void addEquipEvent(IOnEquipEvent event) {
        this.onEquipEvents.add(event);
    }

    public void addRemoveEvent(IOnRemoveEvent event) {
        this.onRemoveEvents.add(event);
    }

    public <A extends IAbility, E extends LivingEntity> void addUseEvent(IOnUse2Event<E, A> event) {
        this.addUseEvent(100, event);
    }

    public <A extends IAbility, E extends LivingEntity> void addUseEvent(int priority, IOnUse2Event<E, A> event) {
        this.onUseEvents.addEvent(priority, event);
    }

    public boolean hasUseEvent(IOnUse2Event event) {
        return this.onUseEvents.getEventsStream().anyMatch(e -> e.equals(event));
    }

    public void removeUseEvent(IOnUse2Event event) {
        this.onUseEvents.removeEvent(event);
    }

    public <T extends LivingEntity, A extends Ability> void addTickEvent(IOnTickEvent<T, A> event) {
        this.onTickEvents.add(event);
    }

    public void addCanUseCheck(ICanUseEvent event) {
        this.onCanUseEvents.add(event);
    }

    public Stream<ICanUseEvent> getCanUseChecksStream() {
        return this.onCanUseEvents.stream();
    }

    @Deprecated
    public boolean isOnStandby() {
        return this.state == State.STANDBY;
    }

    public boolean isOnCooldown() {
        Optional<CooldownComponent> cooldownComponent = this.getComponent(ModAbilityKeys.COOLDOWN);
        return this.state == State.COOLDOWN || cooldownComponent.isPresent() && cooldownComponent.get().isOnCooldown();
    }

    @Deprecated
    public boolean isPassiveEnabled() {
        return this.state == State.PASSIVE;
    }

    public boolean isContinuous() {
        Optional<ContinuousComponent> continuousComponent = this.getComponent(ModAbilityKeys.CONTINUOUS);
        return this.state == State.CONTINUOUS && !this.isStateForced() || continuousComponent.isPresent() && continuousComponent.get().isContinuous();
    }

    public boolean isCharging() {
        Optional<ChargeComponent> chargeComponent = this.getComponent(ModAbilityKeys.CHARGE);
        return this.state == State.CHARGING && !this.isStateForced() || chargeComponent.isPresent() && chargeComponent.get().isCharging();
    }

    public boolean isDisabled() {
        Optional<DisableComponent> disableComponent = this.getComponent(ModAbilityKeys.DISABLE);
        return this.state == State.DISABLED || disableComponent.isPresent() && disableComponent.get().isDisabled();
    }

    @Deprecated
    public void startStandby() {
        this.previousState = this.state;
        this.state = State.STANDBY;
    }

    @Deprecated
    public void startDisable(PlayerEntity player) {
        this.startDisable(player, 20);
    }

    @Deprecated
    public void startDisable(PlayerEntity player, int ticks) {
        this.previousState = this.state;
        this.state = State.DISABLED;
        this.disableTicks = this.maxDisableTicks = (double)ticks;
    }

    @Deprecated
    public void stopDisable(PlayerEntity player) {
        this.cooldown = this.maxCooldown;
        this.startCooldown(player);
    }

    @Deprecated
    public double getDisableTicks() {
        return this.disableTicks;
    }

    @Deprecated
    public void setDisableTicks(double ticks) {
        this.disableTicks = ticks;
    }

    @Deprecated
    public void startCooldown(PlayerEntity player) {
        this.previousState = this.state;
        this.state = State.COOLDOWN;
    }

    @Deprecated
    public void stopCooldown(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.checkAbilityPool(player, State.STANDBY);
        this.cooldown = this.maxCooldown;
        this.previousState = this.state;
        this.state = State.STANDBY;
        if (!this.isStateForced()) {
            this.onEndCooldownEvent.onEndCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (LivingEntity)player);
        }
        this.setForcedState(false);
    }

    @Deprecated
    public void setState(State state) {
        this.previousState = this.state;
        this.state = state;
    }

    @Deprecated
    public State getState() {
        return this.state;
    }

    @Deprecated
    public State getPreviousState() {
        return this.previousState;
    }

    @Deprecated
    public void setForcedState(boolean flag) {
        this.forcedState = flag;
    }

    @Deprecated
    public boolean isStateForced() {
        return this.forcedState;
    }

    @Deprecated
    public void needsClientSide() {
        this.needsClientSide = true;
    }

    @Deprecated
    public boolean isClientSideLegacy() {
        return this.needsClientSide;
    }

    @Deprecated
    public void addInPool(AbilityPool ... pools) {
        int[] intPools = Arrays.stream(pools).mapToInt(AbilityPool::id).toArray();
        this.addInPool(intPools);
    }

    @Deprecated
    public void addInPool(int ... pools) {
        this.pools = pools;
    }

    @Deprecated
    public int[] getPools() {
        return this.pools;
    }

    @Deprecated
    public boolean isInPool() {
        return ((Boolean)AbilitiesConfig.SHARED_COOLDOWNS.get()).booleanValue() ? this.pools != null && this.pools.length > 0 : false;
    }

    @Deprecated
    public boolean isInPool(AbilityPool pool) {
        return this.isInPool(pool.id());
    }

    @Deprecated
    public boolean isInPool(int poolId) {
        if (!((Boolean)AbilitiesConfig.SHARED_COOLDOWNS.get()).booleanValue()) {
            return false;
        }
        return Arrays.stream(this.pools).anyMatch(i -> poolId == i);
    }

    @Deprecated
    public boolean sharesPoolWith(Ability ability) {
        if (!((Boolean)AbilitiesConfig.SHARED_COOLDOWNS.get()).booleanValue()) {
            return false;
        }
        boolean flag = false;
        for (int pool : ability.getPools()) {
            if (!this.isInPool(pool)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Deprecated
    public void setMaxCooldown(double cooldown) {
        this.cooldown = this.maxCooldown = cooldown * 20.0;
    }

    @Deprecated
    public double getMaxCooldown() {
        return this.maxCooldown;
    }

    @Deprecated
    public void setCooldown(double cooldown) {
        this.cooldown = cooldown * 20.0;
    }

    @Deprecated
    public double getCooldown() {
        return this.cooldown;
    }

    @Deprecated
    public void setTimeProgression(double timeScale) {
        this.timeProgression = timeScale;
    }

    @Deprecated
    public double getTimeProgression() {
        return this.timeProgression;
    }

    @Deprecated
    public String getName() {
        return this.getCore().getLocalizedName().getString();
    }

    @Deprecated
    public String getI18nKey() {
        String resourceName = WyHelper.getResourceName(this.getName());
        return "ability.mineminenomi." + resourceName;
    }

    public String getDisplayNameOld() {
        return this.displayName != null ? this.displayName.getString() : this.getCore().getLocalizedName().getString();
    }

    public boolean hasCustomName() {
        return this.displayName != null;
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getCore().getLocalizedName();
    }

    @Deprecated
    public void setDisplayName(String name) {
        this.setDisplayName((ITextComponent)new StringTextComponent(name));
    }

    public void setDisplayName(ITextComponent name) {
        this.displayName = name;
    }

    public boolean hasCustomIcon() {
        return this.displayIcon != null;
    }

    @Deprecated
    public ResourceLocation getIcon(PlayerEntity player) {
        if (this.isNew) {
            return this.getIcon((LivingEntity)player);
        }
        return this.hasCustomIcon() ? this.displayIcon : this.getCore().getIcon();
    }

    @Override
    @Nullable
    public ResourceLocation getIcon(LivingEntity entity) {
        if (this.core.getIcon() == null && this.cachedIcon == null) {
            ResourceLocation key = this.core.getRegistryName();
            if (key != null) {
                this.cachedIcon = new ResourceLocation(key.func_110624_b(), "textures/abilities/" + key.func_110623_a() + ".png");
            }
            return this.cachedIcon;
        }
        if (this.hasCustomIcon()) {
            return this.displayIcon;
        }
        if (this.getCore().getIcon() != null) {
            return this.getCore().getIcon();
        }
        return this.cachedIcon;
    }

    public void setDisplayIcon(@Nullable ResourceLocation texture) {
        this.displayIcon = texture;
    }

    public void setDisplayIcon(AbilityCore<?> core) {
        this.displayIcon = core.getIcon();
    }

    @Deprecated
    public void setCustomIcon(String texture) {
        this.displayIcon = Strings.isNullOrEmpty((String)texture) ? null : new ResourceLocation(this.getCore().getIcon().func_110624_b(), "textures/abilities/" + WyHelper.getResourceName(texture) + ".png");
    }

    public AbilityCategory getCategory() {
        return this.getCore().getCategory();
    }

    @Deprecated
    public void setUnlockType(@Nullable LivingEntity entity, AbilityUnlock unlockType) {
    }

    @Deprecated
    public AbilityUnlock getUnlockType() {
        return this.unlock;
    }

    public SourceHakiNature getSourceHakiNature() {
        return this.getCore().getSourceHakiNature();
    }

    public ArrayList<SourceType> getSourceTypes() {
        return this.getCore().getSourceTypes();
    }

    public boolean hasSourceTypes(SourceType type) {
        return this.getCore().hasType(type);
    }

    public SourceElement getSourceElement() {
        return this.getCore().getSourceElement();
    }

    @Deprecated
    public <T extends LivingEntity> void setOnUseEvent(IOnUse<T> event) {
        this.onUseEvent = event;
    }

    @Deprecated
    public void tick(PlayerEntity player) {
        if (this.isNew) {
            this.tick((LivingEntity)player);
            return;
        }
        if (player.func_175149_v()) {
            this.startDisable(player, 1);
        }
        if (this.isDisabled()) {
            if (this.disableTicks > 0.0) {
                this.disableTicks -= 1.0;
            } else {
                this.stopDisable(player);
            }
        }
        if (this.isOnCooldown()) {
            this.cooldown(player);
        }
        AbilityTickEvent event = new AbilityTickEvent((LivingEntity)player, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public final void tick(LivingEntity entity) {
        if (entity instanceof PlayerEntity && !this.isNew) {
            this.tick((PlayerEntity)entity);
            return;
        }
        if (!entity.field_70170_p.field_72995_K && this.isDisabled()) {
            AbilityHelper.emergencyStopAbility(entity, this);
        }
        this.onTickEvents.forEach(event -> event.tick(entity, this));
        this.components.values().forEach(component -> component.tick(entity));
        AbilityTickEvent event2 = new AbilityTickEvent(entity, this);
        MinecraftForge.EVENT_BUS.post((Event)event2);
    }

    @Deprecated
    public void cooldown(PlayerEntity player) {
        if (WyPatreon.isDevBuild() && FGCommand.NO_COOLDOWN) {
            this.stopCooldown(player);
        }
        if (this.isOnCooldown() && this.cooldown > 0.0) {
            this.cooldown -= 1.0 * this.getTimeProgression();
            if (!player.field_70170_p.field_72995_K && this.getPreviousState() != State.DISABLED && !this.isStateForced()) {
                this.tickCooldown(player);
            }
        } else if (this.isOnCooldown() && this.cooldown <= 0.0) {
            this.stopCooldown(player);
        }
    }

    @Deprecated
    protected void tickCooldown(PlayerEntity player) {
        this.duringCooldownEvent.duringCooldown(player, (int)this.cooldown);
    }

    @Deprecated
    public void checkAbilityPool(PlayerEntity player, State state) {
    }

    public long getLastUseGametime() {
        return this.lastUseTime;
    }

    public void setOGCD() {
        this.isOGCD = true;
    }

    @Override
    public boolean isOGCD() {
        return this.isOGCD;
    }

    @Deprecated
    public double getCooldownPercentage() {
        return this.cooldown / this.maxCooldown * 100.0;
    }

    @Deprecated
    public double getInvertedCooldownPercentage() {
        return (1.0 - this.cooldown / this.maxCooldown) * 100.0;
    }

    public boolean equals(Object abl) {
        if (!(abl instanceof Ability)) {
            return false;
        }
        if (this.getCore() == null || ((Ability)abl).getCore() == null) {
            return false;
        }
        return this.getCore().equals(((Ability)abl).getCore());
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        if (this.isNew) {
            if (this.hasCustomName()) {
                nbt.func_74778_a("displayName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.getDisplayName()));
            }
            if (this.hasCustomIcon()) {
                nbt.func_74778_a("displayIcon", this.displayIcon.toString());
            }
            return nbt;
        }
        nbt.func_74778_a("displayName", Strings.isNullOrEmpty((String)this.getDisplayNameOld()) ? "" : this.getDisplayNameOld());
        nbt.func_74778_a("customTexture", this.hasCustomIcon() ? this.displayIcon.toString() : "");
        nbt.func_74783_a("pools", this.getPools());
        nbt.func_74778_a("unlock", this.getUnlockType().name());
        nbt.func_74778_a("state", this.getState().toString());
        if (this instanceof IExtraUpdateData) {
            CompoundNBT extraData = ((IExtraUpdateData)((Object)this)).getExtraData();
            nbt.func_218657_a("extraData", (INBT)extraData);
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        if (this.isNew) {
            if (nbt.func_74764_b("displayName")) {
                this.setDisplayName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("displayName")));
            }
            if (nbt.func_74764_b("displayIcon")) {
                this.setDisplayIcon(new ResourceLocation(nbt.func_74779_i("displayIcon")));
            }
            return;
        }
        this.addInPool(nbt.func_74759_k("pools"));
        this.setUnlockType(null, AbilityUnlock.valueOf(nbt.func_74779_i("unlock")));
        this.setDisplayName(nbt.func_74779_i("displayName"));
        String customTexture = nbt.func_74779_i("customTexture");
        if (!Strings.isNullOrEmpty((String)customTexture)) {
            this.setDisplayIcon(new ResourceLocation(customTexture));
        }
        this.setState(State.valueOf(nbt.func_74779_i("state")));
        if (this instanceof IExtraUpdateData) {
            CompoundNBT extraData = nbt.func_74775_l("extraData");
            ((IExtraUpdateData)((Object)this)).setExtraData(extraData);
        }
    }

    @Override
    public AbilityCore<? extends IAbility> getCore() {
        return this.core;
    }

    public void addComponents(AbilityComponent ... comps) {
        for (AbilityComponent comp2 : comps) {
            this.components.put(comp2.getKey(), comp2);
        }
        if (FMLEnvironment.dist.isClient()) {
            this.components.values().stream().forEach(c -> c.postInit(this));
        } else {
            this.components.values().stream().filter(comp -> !comp.isClientSided()).forEach(c -> c.postInit(this));
        }
    }

    @Override
    public boolean hasComponent(AbilityComponentKey key) {
        return this.components.containsKey(key);
    }

    @Override
    public <C extends AbilityComponent<?>> Optional<C> getComponent(AbilityComponentKey<C> key) {
        if (!this.hasComponent(key)) {
            return Optional.empty();
        }
        AbilityComponent<?> comp = this.components.get(key);
        if (comp.isClientSided() && !FMLEnvironment.dist.isClient()) {
            return Optional.empty();
        }
        return Optional.of(comp);
    }

    @Override
    public Map<AbilityComponentKey<?>, AbilityComponent<?>> getComponents() {
        return this.components;
    }

    public AbilityUseResult canUse(PlayerEntity player) {
        ProtectedAreasData worldData;
        ProtectedArea area;
        if (this.isNew) {
            return this.canUse((LivingEntity)player);
        }
        if (this.isDisabled()) {
            return AbilityUseResult.fail(null);
        }
        if (!player.field_70170_p.field_72995_K && (area = (worldData = ProtectedAreasData.get(player.field_70170_p)).getProtectedArea(player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177956_o(), player.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getCore())) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_HERE));
        }
        return AbilityUseResult.success();
    }

    @Override
    public final AbilityUseResult canUse(LivingEntity entity) {
        ProtectedAreasData worldData;
        ProtectedArea area;
        if (entity.func_70644_a((Effect)ModEffects.IN_EVENT.get())) {
            return AbilityUseResult.fail(null);
        }
        if (!this.isOGCD && GCDCapability.isOnGCD(entity)) {
            return AbilityUseResult.fail(null);
        }
        if (this.disableComponent.isDisabled()) {
            return AbilityUseResult.fail(null);
        }
        if (this.cooldownComponent.isOnCooldown()) {
            return AbilityUseResult.fail(null);
        }
        Optional<PoolComponent> poolComponent = this.getComponent(ModAbilityKeys.POOL);
        if (poolComponent.isPresent() && poolComponent.get().isPoolInUse()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_POOL_ALREADY_IN_USE));
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        Optional<ContinuousComponent> continuousComponent = this.getComponent(ModAbilityKeys.CONTINUOUS);
        if (continuousComponent.isPresent() && !continuousComponent.get().isContinuous() && !continuousComponent.get().isParallel()) {
            for (IAbility ability : abilityDataProps.getEquippedAbilities()) {
                Optional<ContinuousComponent> otherComponent;
                if (ability.equals(this) || !(otherComponent = ability.getComponent(ModAbilityKeys.CONTINUOUS)).isPresent() || !otherComponent.get().isContinuous() || otherComponent.get().isParallel()) continue;
                if (CommonConfig.INSTANCE.getStopContinuousAbility() && this.hasComponent(ModAbilityKeys.CONTINUOUS)) {
                    otherComponent.get().stopContinuity(entity);
                    continue;
                }
                return AbilityUseResult.fail(null);
            }
        }
        if (continuousComponent.isPresent() && continuousComponent.get().isContinuous()) {
            return AbilityUseResult.success();
        }
        Optional<ChargeComponent> chargeComponent = this.getComponent(ModAbilityKeys.CHARGE);
        if (chargeComponent.isPresent() && chargeComponent.get().isCharging()) {
            return AbilityUseResult.success();
        }
        Optional<AbilityUseResult> canUseResult = this.onCanUseEvents.stream().map(event -> event.canUse(entity, this)).filter(result -> result.isFail()).findFirst();
        if (canUseResult.isPresent()) {
            return canUseResult.get();
        }
        if (!entity.field_70170_p.field_72995_K && (area = (worldData = ProtectedAreasData.get(entity.field_70170_p)).getProtectedArea(entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getCore())) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_HERE));
        }
        return AbilityUseResult.success();
    }

    public boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    @FunctionalInterface
    public static interface IOnRemoveEvent {
        public void onRemove(LivingEntity var1, Ability var2);
    }

    @FunctionalInterface
    public static interface IOnEquipEvent {
        public void onEquip(LivingEntity var1, Ability var2);
    }

    @FunctionalInterface
    public static interface IOnTickEvent<T extends LivingEntity, A extends IAbility> {
        public void tick(T var1, A var2);
    }

    @FunctionalInterface
    public static interface IOnUse2Event<T extends LivingEntity, A extends IAbility> {
        public void onUse(T var1, A var2);
    }

    @FunctionalInterface
    public static interface ICanUseEvent<T extends LivingEntity, A extends IAbility> {
        public AbilityUseResult canUse(T var1, A var2);

        default public ICanUseEvent<T, A> and(ICanUseEvent<T, A> check) {
            return (entity, ability) -> {
                AbilityUseResult result1 = this.canUse(entity, ability);
                if (result1.isFail()) {
                    return result1;
                }
                AbilityUseResult result2 = check.canUse(entity, ability);
                if (result2.isFail()) {
                    return result2;
                }
                return AbilityUseResult.success();
            };
        }

        default public ICanUseEvent<T, A> or(ICanUseEvent<T, A> check) {
            return (entity, ability) -> {
                AbilityUseResult result1 = this.canUse(entity, ability);
                AbilityUseResult result2 = check.canUse(entity, ability);
                return result1.isSuccess() || result2.isSuccess() ? AbilityUseResult.success() : (result1.isFail() ? result1 : result2);
            };
        }

        default public ICanUseEvent<T, A> not() {
            return (entity, ability) -> {
                AbilityUseResult result = this.canUse(entity, ability);
                return result.isSuccess() ? AbilityUseResult.fail(null) : AbilityUseResult.success();
            };
        }
    }

    @Deprecated
    public static interface IOnEndCooldown
    extends Serializable {
        public void onEndCooldown(PlayerEntity var1);
    }

    @Deprecated
    public static interface IDuringCooldown
    extends Serializable {
        public void duringCooldown(PlayerEntity var1, int var2);
    }

    @Deprecated
    public static interface IOnUse<T extends LivingEntity>
    extends Serializable {
        public boolean onUse(T var1);
    }

    @Deprecated
    public static interface IFactory<A extends Ability> {
        public A create(AbilityCore<A> var1);
    }

    @Deprecated
    public static enum State {
        STANDBY,
        DISABLED,
        COOLDOWN,
        PASSIVE,
        CONTINUOUS,
        CHARGING;

    }
}

