/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.IExtensibleEnum;
import xyz.pixelatedw.mineminenomi.abilities.mera.DaiEnkaiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public enum AbilityCategory implements IExtensibleEnum
{
    DEVIL_FRUITS(AbilityHelper.DF_CATEGORY_ICON),
    RACIAL(AbilityHelper.RACE_CATEGORY_ICON),
    STYLE(null),
    HAKI(AbilityHelper.HAKI_CATEGORY_ICON),
    FACTION(null),
    EQUIPMENT(null),
    ALL(null);

    private Function<PlayerEntity, ResourceLocation> iconFunction = entity -> DaiEnkaiAbility.INSTANCE.getIcon();

    private AbilityCategory(Function<PlayerEntity, ResourceLocation> function) {
        this.iconFunction = function;
    }

    @Nullable
    public ResourceLocation getIcon(PlayerEntity player) {
        if (this.iconFunction == null || player == null) {
            return null;
        }
        return this.iconFunction.apply(player);
    }

    public Predicate<IAbility> isAbilityPartofCategory() {
        if (this == ALL) {
            return abl -> true;
        }
        return abl -> abl.getCore().getCategory().equals((Object)this);
    }

    public Predicate<AbilityCore> isCorePartofCategory() {
        if (this == ALL) {
            return core -> true;
        }
        return core -> core.getCategory().equals((Object)this);
    }

    public static AbilityCategory create(String name, Function<PlayerEntity, ResourceLocation> function) {
        throw new IllegalStateException("Enum not extended");
    }
}

