/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;

public class AbilityDescriptionLine {
    public static final IDescriptionLine NEW_LINE = (e, a) -> new StringTextComponent(" ");
    public static final IDescriptionLine DOUBLE_NEW_LINE = (e, a) -> new StringTextComponent(System.getProperty("line.separator"));
    @Nullable
    private ITextComponent staticLine;
    @Nullable
    private IDescriptionLine dynamicLine;
    private boolean isAdvanced;

    private AbilityDescriptionLine(IDescriptionLine line, boolean isAdvanced) {
        this.dynamicLine = line;
        this.isAdvanced = isAdvanced;
    }

    private AbilityDescriptionLine(ITextComponent line, boolean isAdvanced) {
        this.staticLine = line;
        this.isAdvanced = isAdvanced;
    }

    public static AbilityDescriptionLine of(IDescriptionLine line) {
        return new AbilityDescriptionLine(line, false);
    }

    public static AbilityDescriptionLine of(IDescriptionLine line, boolean isAdvanced) {
        return new AbilityDescriptionLine(line, isAdvanced);
    }

    public static AbilityDescriptionLine of(ITextComponent text) {
        return new AbilityDescriptionLine(text, false);
    }

    public static AbilityDescriptionLine of(ITextComponent text, boolean isAdvanced) {
        return new AbilityDescriptionLine(text, isAdvanced);
    }

    @Nullable
    public ITextComponent getTextComponent(LivingEntity entity, IAbility ability) {
        if (this.staticLine != null) {
            return this.staticLine;
        }
        return this.dynamicLine.expand(entity, ability);
    }

    @Nullable
    public ITextComponent getStaticTextComponent() {
        return this.staticLine;
    }

    public boolean isStatic() {
        return this.staticLine != null;
    }

    public boolean isDynamic() {
        return this.dynamicLine != null;
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    @FunctionalInterface
    public static interface IDescriptionLine<A extends IAbility> {
        public ITextComponent expand(LivingEntity var1, A var2);

        public static IDescriptionLine of(ITextComponent text) {
            return (e, a) -> text;
        }
    }
}

