/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;

public class AbilityPool2 {
    private final Set<AbilityCore<?>> abilities = new HashSet();
    private final HashMap<String, FlagValue<?>> flags = new HashMap();

    public AbilityPool2 addFlag(String flag, boolean value) {
        this.flags.put(flag, new BooleanFlagValue(value));
        return this;
    }

    public <T> T getFlagValue(String flag, Supplier<T> defaultValue) {
        FlagValue<?> value = this.flags.get(flag);
        if (value != null) {
            return (T)value.get();
        }
        return defaultValue.get();
    }

    public void addAbilityCore(AbilityCore<?> core) {
        this.abilities.add(core);
    }

    public boolean hasAbilityCore(AbilityCore<?> core) {
        return this.abilities.contains(core);
    }

    public Stream<AbilityCore<?>> getAllPoolCores() {
        return this.abilities.stream();
    }

    public static class BooleanFlagValue
    extends FlagValue<Boolean> {
        public BooleanFlagValue(Boolean value) {
            super(value);
        }
    }

    public static abstract class FlagValue<T> {
        protected T value;

        public FlagValue(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }
    }
}

