/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.io.Serializable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAnimatedAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Deprecated
public abstract class ContinuousAbility
extends Ability {
    protected int threshold = 0;
    protected int continueTime = 0;
    protected IOnStartContinuity onStartContinuityEvent = player -> true;
    protected IDuringContinuity duringContinuityEvent = (player, continuousTime) -> {};
    protected IBeforeContinuityStop beforeContinuityStopEvent = player -> true;
    protected IAfterContinuityStop afterContinuityStopEvent = player -> {};

    public ContinuousAbility(AbilityCore core) {
        super(core);
    }

    @Override
    public void use(PlayerEntity player) {
        AbilityUseEvent.Pre pre;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(pre = new AbilityUseEvent.Pre((LivingEntity)player, this)))) {
            return;
        }
        if (!this.isContinuous()) {
            if (!this.isOnStandby()) {
                return;
            }
            if (this.hasAbilityFromSamePoolEnabled(player)) {
                return;
            }
            if (this.onStartContinuityEvent.onStartContinuity(player)) {
                this.checkAbilityPool(player, Ability.State.CONTINUOUS);
                if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue() && !(this instanceof PunchAbility)) {
                    WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getDisplayNameOld()), (LivingEntity)player);
                }
                AbilityUseEvent.Post post = new AbilityUseEvent.Post((LivingEntity)player, this);
                MinecraftForge.EVENT_BUS.post((Event)post);
                this.startContinuity(player);
                if (this instanceof IAnimatedAbility) {
                    WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityPacket(player.func_145782_y(), this), (LivingEntity)player);
                }
                WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (LivingEntity)player);
            }
        } else if (!this.isStateForced()) {
            this.tryStoppingContinuity(player);
        }
    }

    @Override
    public void startDisable(PlayerEntity player, int ticks) {
        if (this.isContinuous()) {
            this.tryStoppingContinuity(player);
        }
        super.startDisable(player, ticks);
    }

    public void setThreshold(double threshold) {
        this.threshold = (int)(threshold * 20.0);
    }

    public void setThresholdInTicks(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setContinueTime(int time) {
        this.continueTime = time * 20;
    }

    public int getContinueTime() {
        return this.continueTime;
    }

    @Override
    public void tick(PlayerEntity player) {
        super.tick(player);
        if (this.isContinuous()) {
            if (this.canUse(player).isFail()) {
                this.stopContinuity(player);
                return;
            }
            ++this.continueTime;
            if (!(!this.isClientSideLegacy() && player.field_70170_p.field_72995_K || this.isStateForced())) {
                this.tickContinuity(player);
            }
            if (this.threshold > 0 && this.continueTime >= this.threshold) {
                this.tryStoppingContinuity(player);
            }
        }
    }

    protected void tickContinuity(PlayerEntity player) {
        this.duringContinuityEvent.duringContinuity(player, this.continueTime);
    }

    public void startContinuity(PlayerEntity player) {
        this.setState(Ability.State.CONTINUOUS);
    }

    public void tryStoppingContinuity(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.beforeContinuityStopEvent.fire(player)) {
            this.stopContinuity(player);
        }
    }

    public void stopContinuity(PlayerEntity player) {
        this.checkAbilityPool(player, Ability.State.COOLDOWN);
        this.startCooldown(player);
        this.afterContinuityStopEvent.fire(player);
        this.continueTime = 0;
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((LivingEntity)player, this), (LivingEntity)player);
        }
    }

    public boolean hasAbilityFromSamePoolEnabled(PlayerEntity player) {
        return false;
    }

    public static interface IAfterContinuityStop
    extends Serializable {
        public void fire(PlayerEntity var1);
    }

    public static interface IBeforeContinuityStop
    extends Serializable {
        public boolean fire(PlayerEntity var1);
    }

    public static interface IOnStartContinuity
    extends Serializable {
        public boolean onStartContinuity(PlayerEntity var1);
    }

    public static interface IDuringContinuity
    extends Serializable {
        public void duringContinuity(PlayerEntity var1, int var2);
    }
}

