/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;

public abstract class DashAbility
extends Ability {
    private static final TargetsPredicate TARGET_CHECK = TargetsPredicate.DEFAULT_AREA_CHECK;
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, this.isParallel()).addStartEvent(200, this::startContinuityEvent).addTickEvent(200, this::duringContinuity).addEndEvent(200, this::endContinuityEvent);
    protected final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    protected final RangeComponent rangeComponent = new RangeComponent(this);
    protected final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public DashAbility(AbilityCore<? extends DashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTrackerComponent, this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(200, this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, this.getHoldTime());
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        double dashSpeed = this.getSpeed();
        Vector3d speed = entity.func_70040_Z().func_216372_d(dashSpeed, 0.0, dashSpeed);
        entity.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        entity.field_70133_I = true;
    }

    private void duringContinuity(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, this.getRange(), this.getTargetCheck());
            float damage = this.getDamage();
            DamageSource source = this.getDamageSource(entity);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, damage, source)) continue;
                this.onTargetHit(entity, target, damage, source);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, this.getDashCooldown());
    }

    public abstract void onTargetHit(LivingEntity var1, LivingEntity var2, float var3, DamageSource var4);

    public DamageSource getDamageSource(LivingEntity entity) {
        return this.dealDamageComponent.getDamageSource(entity);
    }

    public TargetsPredicate getTargetCheck() {
        return TARGET_CHECK;
    }

    public boolean isParallel() {
        return false;
    }

    public abstract float getDashCooldown();

    public abstract float getDamage();

    public abstract float getRange();

    public abstract double getSpeed();

    public int getHoldTime() {
        return 10;
    }
}

