/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.KairosekiBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ExplosionAbility
extends Explosion {
    private World world;
    private Entity exploder;
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private float explosionSize;
    private ParticleEffect particles;
    private DamageSource damageSource;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> playerKnockbackMap = Maps.newHashMap();
    public List<FallingBlockEntity> removedBlocks = Lists.newArrayList();
    private final Random random = new Random();
    private boolean canStartFireAfterExplosion = false;
    private boolean canDestroyBlocks = true;
    private boolean canDropBlocksAfterExplosion = false;
    private boolean canDamageEntities = true;
    private boolean checkForFaction = true;
    private boolean canDamageOwner = false;
    private boolean canDamageOnce = true;
    private boolean canProduceExplosionSound = true;
    private boolean protectOwnerFromFalling = false;
    private boolean canCauseKnockback = true;
    private boolean addRemovedBlocksToList = false;
    private boolean hasBlockLimit = false;
    private float staticDamage = 0.0f;
    private float staticBlockResistance = 0.0f;
    private int heightDifference = 0;
    private int explodedBlocksLimit;
    private int size = 52;
    private int explodedBlocks;
    public ArrayList<Entity> immuneEntities = new ArrayList();
    public ArrayList<Entity> damagedEntities = new ArrayList();
    private static final ArrayList<Entity> DAMAGED_ENTITIES = new ArrayList();
    public IOnBlockDestroyed onBlockDestroyedEvent = hitPos -> {};

    public ExplosionAbility(Entity entity, World world, double posX, double posY, double posZ, float power) {
        super(world, entity, (DamageSource)null, (ExplosionContext)null, posX, posY, posZ, power, false, Explosion.Mode.DESTROY);
        this.world = world;
        this.exploder = entity;
        this.explosionSize = power;
        this.explosionX = posX;
        this.explosionY = posY;
        this.explosionZ = posZ;
        this.damageSource = DamageSource.func_94539_a((Explosion)this);
    }

    public void setExplosionPos(double posX, double posY, double posZ) {
        this.explosionX = posX;
        this.explosionY = posY;
        this.explosionZ = posZ;
    }

    public void setExplosionSize(float explosionSize) {
        this.explosionSize = explosionSize;
    }

    public void setExplodedBlocksLimit(int limit) {
    }

    public void setHasBlockLimit(boolean hasBlockLimit) {
        this.hasBlockLimit = hasBlockLimit;
    }

    public double getStaticDamage() {
        return this.staticDamage;
    }

    public void setStaticDamage(float damage) {
        this.staticDamage = damage;
    }

    public double getStaticBlockResistance() {
        return this.staticBlockResistance;
    }

    public void setStaticBlockResistance(float damage) {
        this.staticBlockResistance = damage;
    }

    public void setHeightDifference(int heightDifference) {
        this.heightDifference = heightDifference;
    }

    public void setDamageOwner(boolean damageOwner) {
        this.canDamageOwner = damageOwner;
    }

    public void setDamageEntities(boolean damageEntities) {
        this.canDamageEntities = damageEntities;
    }

    public void ignoreFactionChecks() {
        this.checkForFaction = false;
    }

    public void setDropBlocksAfterExplosion(boolean canDrop) {
        this.canDropBlocksAfterExplosion = canDrop;
    }

    public void setFireAfterExplosion(boolean hasFire) {
        this.canStartFireAfterExplosion = hasFire;
    }

    public void setDestroyBlocks(boolean canDestroyBlocks) {
        this.canDestroyBlocks = canDestroyBlocks;
    }

    public void setSmokeParticles(ParticleEffect particle) {
        this.particles = particle;
    }

    public boolean getDamageOnce() {
        return this.canDamageOnce;
    }

    public void setDamageOnce(boolean flag) {
        this.canDamageOnce = flag;
    }

    public void addRemovedBlocksToList() {
        this.addRemovedBlocksToList = true;
    }

    public void setProtectOwnerFromFalling(boolean flag) {
        this.protectOwnerFromFalling = flag;
    }

    public boolean hasSmokeParticles() {
        return this.particles != null;
    }

    public void setExplosionSound(boolean hasSound) {
        this.canProduceExplosionSound = hasSound;
    }

    private void resetDamage(LivingEntity entity) {
        entity.field_70172_ad = 0;
        entity.field_70737_aN = 0;
    }

    public void disableExplosionKnockback() {
        this.canCauseKnockback = false;
    }

    public DamageSource func_199591_b() {
        return this.damageSource;
    }

    public void setDamageSource(DamageSource damageSourceIn) {
        this.damageSource = damageSourceIn;
    }

    public int getExplodedBlocks() {
        return this.explodedBlocks;
    }

    public void doExplosion() {
        List list;
        if (ForgeEventFactory.onExplosionStart((World)this.world, (Explosion)this)) {
            return;
        }
        if (this.heightDifference > 0 && this.exploder != null && this.exploder.func_226278_cu_() - (double)this.heightDifference > this.explosionY) {
            return;
        }
        HashSet set = Sets.newHashSet();
        if ((float)(this.size + 4) > this.explosionSize) {
            this.size = Math.max((int)(this.explosionSize + 4.0f), 16);
        }
        BlockPos.Mutable foundBlockPos = new BlockPos.Mutable();
        for (int j = 0; j < this.size; ++j) {
            for (int k = 0; k < this.size; ++k) {
                block2: for (int l = 0; l < this.size; ++l) {
                    if (j != 0 && j != this.size - 1 && k != 0 && k != this.size - 1 && l != 0 && l != this.size - 1) continue;
                    double d0 = (float)j / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d1 = (float)k / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d2 = (float)l / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double eX = this.explosionX;
                    double eY = this.explosionY;
                    double eZ = this.explosionZ;
                    float f1 = 0.3f;
                    for (float power = this.explosionSize * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); power > 0.0f; power -= 0.22500001f) {
                        foundBlockPos.func_189532_c(eX, eY, eZ);
                        BlockState blockState = this.world.func_180495_p((BlockPos)foundBlockPos);
                        FluidState ifluidstate = this.world.func_204610_c((BlockPos)foundBlockPos);
                        if (!ifluidstate.func_206888_e()) continue block2;
                        if (!blockState.func_196958_f() || !ifluidstate.func_206888_e()) {
                            float blockExplosionResistance = Math.max(blockState.getExplosionResistance((IBlockReader)this.world, (BlockPos)foundBlockPos, (Explosion)this), ifluidstate.getExplosionResistance((IBlockReader)this.world, (BlockPos)foundBlockPos, (Explosion)this));
                            if (this.exploder != null) {
                                blockExplosionResistance = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, (BlockPos)foundBlockPos, blockState, ifluidstate, blockExplosionResistance);
                            }
                            power = (float)((double)power - (this.getStaticBlockResistance() > 0.0 ? this.getStaticBlockResistance() : (double)((blockExplosionResistance + 0.3f) * 0.1f)));
                        }
                        if (power > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, (BlockPos)foundBlockPos, blockState, power)) && !blockState.func_235714_a_(ModTags.Blocks.KAIROSEKI)) {
                            set.add(foundBlockPos.func_185334_h());
                        }
                        eX += d0 * (double)0.3f;
                        eY += d1 * (double)0.3f;
                        eZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float size = this.explosionSize * 2.0f;
        Vector3d explosionPos = new Vector3d(this.explosionX, this.explosionY, this.explosionZ);
        if (this.getExploder() instanceof LivingEntity) {
            Predicate<Entity> factionCheck = null;
            if (this.checkForFaction) {
                factionCheck = ModEntityPredicates.getEnemyFactions((LivingEntity)this.getExploder());
            }
            list = WyHelper.getNearbyEntities(explosionPos, (IWorld)this.world, (double)size, size, size, factionCheck, Entity.class);
        } else {
            list = WyHelper.getNearbyEntities(explosionPos, (IWorld)this.world, (double)size, size, size, null, Entity.class);
        }
        if (this.canDamageOwner) {
            list.add(this.getExploder());
        }
        list = list.stream().filter(e -> {
            DamageSource source;
            if (e instanceof LivingEntity && (source = this.func_199591_b()).func_76364_f() != null) {
                return ((LivingEntity)e).func_70685_l(source.func_76364_f());
            }
            return true;
        }).collect(Collectors.toList());
        if (this.immuneEntities.size() > 0) {
            list.removeAll(this.immuneEntities);
        }
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, list, (double)size);
        Vector3d v3d = new Vector3d(this.explosionX, this.explosionY, this.explosionZ);
        if (this.canDamageEntities) {
            for (int k2 = 0; k2 < list.size(); ++k2) {
                PlayerEntity playerEntity;
                double zDistance;
                double yDistance;
                double xDistance;
                double squareDistance;
                double distance;
                Entity entity = (Entity)list.get(k2);
                if (entity == null || !entity.func_70089_S()) {
                    if (!DAMAGED_ENTITIES.contains(entity)) continue;
                    DAMAGED_ENTITIES.remove(entity);
                    continue;
                }
                if (DAMAGED_ENTITIES.contains(entity) && entity instanceof LivingEntity && ((LivingEntity)entity).field_70737_aN == 0 && entity.field_70172_ad == 0) {
                    DAMAGED_ENTITIES.remove(entity);
                }
                if (entity.func_180427_aV() || !((distance = entity.func_70092_e(this.explosionX, this.explosionY, this.explosionZ) / (double)size) <= 1.0) || (squareDistance = (double)MathHelper.func_76133_a((double)((xDistance = entity.func_226277_ct_() - this.explosionX) * xDistance + (yDistance = entity.func_226278_cu_() + (double)entity.func_70047_e() - this.explosionY) * yDistance + (zDistance = entity.func_226281_cx_() - this.explosionZ) * zDistance))) == 0.0) continue;
                xDistance /= squareDistance;
                yDistance /= squareDistance;
                zDistance /= squareDistance;
                double blockDensity = this.getStaticBlockResistance() > 0.0 ? 0.0 : (double)Explosion.func_222259_a((Vector3d)v3d, (Entity)entity);
                double power = (1.0 - distance) * blockDensity;
                if (entity instanceof LivingEntity && !DAMAGED_ENTITIES.contains(entity) && this.getDamageOnce()) {
                    this.resetDamage((LivingEntity)entity);
                }
                if (this.staticDamage > 0.0f) {
                    if (entity.func_70097_a(this.func_199591_b(), this.staticDamage)) {
                        this.damagedEntities.add(entity);
                        DAMAGED_ENTITIES.add(entity);
                    }
                } else {
                    float damage = (float)((power * power + power) / 2.0 * 7.0 * (double)size + 1.0);
                    if (entity.func_70097_a(this.func_199591_b(), damage)) {
                        this.damagedEntities.add(entity);
                        DAMAGED_ENTITIES.add(entity);
                    }
                }
                double blastDamageReduction = power;
                if (entity instanceof LivingEntity) {
                    blastDamageReduction = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)power);
                }
                if (!this.canCauseKnockback) continue;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(xDistance * blastDamageReduction, yDistance * blastDamageReduction, zDistance * blastDamageReduction));
                if (!(entity instanceof PlayerEntity) || (playerEntity = (PlayerEntity)entity).func_175149_v() || playerEntity.func_184812_l_() && playerEntity.field_71075_bZ.field_75100_b) continue;
                this.playerKnockbackMap.put(playerEntity, new Vector3d(xDistance * power, yDistance * power, zDistance * power));
            }
        }
        if (this.canProduceExplosionSound) {
            this.world.func_184148_a((PlayerEntity)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 3.0f + this.explosionSize, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.world.func_184148_a((PlayerEntity)null, this.explosionX, this.explosionY, this.explosionZ, (SoundEvent)ModSounds.GENERIC_EXPLOSION_SHORT.get(), SoundCategory.BLOCKS, 3.0f + this.explosionSize, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.hasSmokeParticles()) {
            this.particles.spawn(this.world, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (!this.world.field_72995_K && this.canDestroyBlocks && CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            for (BlockPos blockpos : this.affectedBlockPositions) {
                if (this.hasBlockLimit && this.explodedBlocks >= this.explodedBlocksLimit) break;
                BlockState blockstate = this.world.func_180495_p(blockpos);
                if (blockstate.func_185904_a() == Material.field_151586_h && !CommonConfig.INSTANCE.getDestroyWater()) continue;
                boolean blockIsKairoseki = KairosekiBlockProtectionRule.INSTANCE.isBanned(blockstate);
                boolean blockIsRestricted = RestrictedBlockProtectionRule.INSTANCE.isBanned(blockstate);
                boolean hardBlockRestriction = false;
                boolean inProtectedAreaFlag = ProtectedAreasData.get(this.world).isInsideRestrictedArea(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
                boolean canGrief = AbilityHelper.canMobGrief(this.getExploder());
                boolean fallingProtection = true;
                if (this.protectOwnerFromFalling && this.exploder != null) {
                    boolean bl = fallingProtection = Math.sqrt(this.exploder.func_70092_e((double)blockpos.func_177958_n(), this.exploder.func_226278_cu_(), (double)blockpos.func_177952_p())) > 1.5;
                }
                if (!blockstate.func_196958_f() && !blockIsKairoseki && !blockIsRestricted && !hardBlockRestriction && fallingProtection && canGrief) {
                    if (this.world instanceof ServerWorld && blockstate.canDropFromExplosion((IBlockReader)this.world, blockpos, (Explosion)this)) {
                        if (this.canDropBlocksAfterExplosion) {
                            TileEntity tileentity = blockstate.hasTileEntity() ? this.world.func_175625_s(blockpos) : null;
                            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.exploder);
                            lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.explosionSize));
                            blockstate.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> ExplosionAbility.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos));
                        }
                        if (this.addRemovedBlocksToList) {
                            this.removedBlocks.add(new FallingBlockEntity(this.world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), blockstate));
                        }
                    }
                    this.onBlockDestroyedEvent.onBlockDestroyed(blockpos);
                    blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                    ++this.explodedBlocks;
                }
                if (!this.canStartFireAfterExplosion || !this.world.func_180495_p(blockpos).func_196958_f() || !this.world.func_180495_p(blockpos.func_177977_b()).func_200015_d((IBlockReader)this.world, blockpos.func_177977_b()) || this.random.nextInt(5) != 0 || inProtectedAreaFlag) continue;
                this.world.func_175656_a(blockpos, AbstractFireBlock.func_235326_a_((IBlockReader)this.world, (BlockPos)blockpos));
            }
        }
        if (this.exploder instanceof ServerPlayerEntity && StructuresHelper.isInsideShip((ServerWorld)this.world, new BlockPos(v3d))) {
            ModAdvancements.SUBTLE_TWEAKS.trigger((ServerPlayerEntity)this.exploder);
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack itemStack, BlockPos pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)itemStack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)itemStack, (int)16);
            drops.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!itemStack.func_190926_b()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)itemStack, (Object)pos));
    }

    public Map<PlayerEntity, Vector3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public static interface IOnBlockDestroyed
    extends Serializable {
        public void onBlockDestroyed(BlockPos var1);
    }
}

