/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ItemSpawnComponent;

public abstract class ItemAbility2
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(90, this::startContinuityEvent).addEndEvent(90, this::endContinuityEvent);
    protected final ItemSpawnComponent itemSpawnComponent = new ItemSpawnComponent(this).addMissingItemEvent(90, this::missingItemEvent);

    public ItemAbility2(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.itemSpawnComponent);
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.spawnItem(entity, this.createItemStack(entity));
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.itemSpawnComponent.despawnItems(entity);
    }

    private void missingItemEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    public abstract ItemStack createItemStack(LivingEntity var1);
}

