/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public abstract class OutOfBodyAbility<T extends LivingEntity>
extends Ability {
    private T body;
    private BlockPos pivotPoint;
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(200, this::startContinuityEvent).addTickEvent(200, this::duringContinuityEvent).addEndEvent(200, this::stopContinuityEvent);

    public OutOfBodyAbility(AbilityCore core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck((entity, ability) -> {
            if (AbilityHelper.isInCreativeOrSpectator(entity)) {
                return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_SUVIVAL_ONLY);
            }
            return AbilityUseResult.success();
        });
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, this.getHoldTime());
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.setPivotPoint(this.body.func_233580_cy_());
        entity.func_230245_c_(false);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75100_b = true;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71016_p();
            }
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.body != null) {
            entity.func_70634_a((double)this.getPivotPoint().func_177958_n(), (double)this.getPivotPoint().func_177956_o(), (double)this.getPivotPoint().func_177952_p());
            this.body.func_70106_y();
            this.body = null;
        }
        if (!this.isPhysical()) {
            entity.field_70145_X = false;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75100_b = false;
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71016_p();
            }
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        if (!this.isPhysical()) {
            entity.func_230245_c_(false);
            entity.field_70145_X = true;
            entity.func_70066_B();
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (Math.sqrt(entity.func_70092_e((double)this.getPivotPoint().func_177958_n(), (double)this.getPivotPoint().func_177956_o(), (double)this.getPivotPoint().func_177952_p())) > (double)this.getMaxRange() || this.getOriginalBody() == null) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if ((double)this.getPivotPoint().func_177958_n() != this.getOriginalBody().func_213303_ch().field_72450_a || (double)this.getPivotPoint().func_177952_p() != this.getOriginalBody().func_213303_ch().field_72449_c || (double)this.getPivotPoint().func_177956_o() != this.getOriginalBody().func_213303_ch().field_72448_b) {
            this.setPivotPoint(this.getOriginalBody().func_233580_cy_());
        }
        if (this.getOriginalBody() == null) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (!this.getOriginalBody().func_70089_S()) {
            entity.func_70097_a(ModDamageSource.OUT_OF_BODY, entity.func_110138_aP());
        }
    }

    public T getOriginalBody() {
        return this.body;
    }

    public double getDistanceFromPivot(Entity entity) {
        if (this.getPivotPoint() == null) {
            return -1.0;
        }
        return Math.sqrt(entity.func_70092_e((double)this.getPivotPoint().func_177958_n(), (double)this.getPivotPoint().func_177956_o(), (double)this.getPivotPoint().func_177952_p()));
    }

    public void setOriginalBody(T body) {
        this.body = body;
    }

    public BlockPos getPivotPoint() {
        return this.pivotPoint;
    }

    public void setPivotPoint(BlockPos pos) {
        this.pivotPoint = pos;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        if (this.pivotPoint != null) {
            nbt.func_74780_a("x", (double)this.pivotPoint.func_177958_n());
            nbt.func_74780_a("y", (double)this.pivotPoint.func_177956_o());
            nbt.func_74780_a("z", (double)this.pivotPoint.func_177952_p());
        }
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        double x = nbt.func_74769_h("x");
        double y = nbt.func_74769_h("y");
        double z = nbt.func_74769_h("z");
        this.pivotPoint = new BlockPos(x, y, z);
    }

    public int getHoldTime() {
        return -1;
    }

    public boolean isActive() {
        return this.continuousComponent.isContinuous();
    }

    public abstract float getMaxRange();

    public abstract boolean isPhysical();
}

