/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public abstract class PunchAbility2
extends Ability {
    protected final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, this.isParallel()).addStartEvent(90, this::startContinuityEvent).addTickEvent(90, this::tickContinuityEvent).addEndEvent(90, this::endContinuityEvent);
    protected final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    protected final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addTryHitEvent(200, this::tryHitEvent).addOnHitEvent(200, this::onHitEvent);
    private int uses = 0;
    private boolean markForStopping;

    public PunchAbility2(AbilityCore<? extends PunchAbility2> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.statsComponent, this.hitTriggerComponent);
        this.addUseEvent(200, this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, this.getPunchHoldTime());
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.uses = 0;
        this.markForStopping = false;
        this.statsComponent.applyModifiers(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.markForStopping) {
            this.continuousComponent.stopContinuity(entity);
            this.markForStopping = false;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.statsComponent.removeModifiers(entity);
        float cooldown = this.getPunchCooldown();
        if (cooldown > 0.0f) {
            this.cooldownComponent.startCooldown(entity, cooldown);
        }
    }

    private HitTriggerComponent.HitResult tryHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.canActivate().test(entity)) {
            return HitTriggerComponent.HitResult.HIT;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private void onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (!source.isBlocked()) {
            this.onHitEffect(entity, target, source);
        }
        this.increaseUses();
    }

    public void increaseUses() {
        ++this.uses;
        if (this.getUseLimit() > 0 && this.uses >= this.getUseLimit()) {
            this.markForStopping = true;
        }
    }

    public float getPunchDamage() {
        return 0.0f;
    }

    public abstract float getPunchCooldown();

    public abstract void onHitEffect(LivingEntity var1, LivingEntity var2, ModDamageSource var3);

    public float getPunchHoldTime() {
        return -1.0f;
    }

    public boolean isParallel() {
        return false;
    }

    public abstract Predicate<LivingEntity> canActivate();

    public abstract int getUseLimit();
}

