/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class RunningSmashAbility
extends PassiveAbility2 {
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    protected static final float DEFAULT_RANGE = 1.5f;
    protected static final float DEFAULT_DAMAGE = 2.0f;
    private float area;
    private float damage;

    public RunningSmashAbility(AbilityCore core) {
        this(core, 1.5f, 2.0f);
    }

    public RunningSmashAbility(AbilityCore core, float area, float damage) {
        super(core);
        this.area = area;
        this.damage = damage;
        this.addComponents(this.rangeComponent, this.dealDamageComponent);
        this.addDuringPassiveEvent(this::duringPassiveEvent);
    }

    private void duringPassiveEvent(LivingEntity entity) {
        if (entity.func_70051_ag() && this.canSmash(entity)) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.0f, this.area);
            targets.removeIf(e -> e.func_184187_bx() != null && e.func_184187_bx().equals((Object)entity));
            for (LivingEntity target : targets) {
                if (!this.dealDamageComponent.hurtTarget(entity, target, this.damage)) continue;
                Vector3d speed = WyHelper.propulsion(entity, 2.0, 2.0);
                target.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
            }
        }
    }

    public abstract boolean canSmash(LivingEntity var1);
}

