/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.WeatherBallKind;
import xyz.pixelatedw.mineminenomi.api.events.ability.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.WeatherCloudEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public abstract class TempoAbility
extends PassiveAbility2 {
    public static AbilityDescriptionLine.IDescriptionLine getTooltip(boolean requiresCloud, int amount, WeatherBallKind kind) {
        return (e, a) -> {
            TranslationTextComponent tooltip = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_TEMPO_SAME_TYPE_COMBINATION, new Object[]{amount, kind.toString()});
            if (requiresCloud) {
                tooltip.func_240702_b_("\n");
                tooltip.func_230529_a_((ITextComponent)ModI18n.ABILITY_DESCRIPTION_TEMPO_REQUIRES_WEATHER_CLOUD);
            }
            return tooltip;
        };
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(boolean requiresCloud, WeatherBallKind ... balls) {
        return (e, a) -> {
            WeatherBallKind previousKind = null;
            boolean sameType = true;
            for (WeatherBallKind kind : balls) {
                if (previousKind == null) {
                    previousKind = kind;
                    continue;
                }
                if (kind.equals((Object)previousKind)) continue;
                sameType = false;
                break;
            }
            TranslationTextComponent tooltip = null;
            if (sameType) {
                tooltip = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_TEMPO_SAME_TYPE_COMBINATION, new Object[]{balls.length, balls[0].toString()});
            }
            if (balls.length == 2) {
                tooltip = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_TEMPO_COMBINATION_2, new Object[]{balls[0].toString(), balls[1].toString()});
            } else if (balls.length == 3) {
                tooltip = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_TEMPO_COMBINATION_3, new Object[]{balls[0].toString(), balls[1].toString(), balls[2].toString()});
            }
            if (tooltip != null && requiresCloud) {
                tooltip.func_240702_b_("\n");
                tooltip.func_230529_a_((ITextComponent)ModI18n.ABILITY_DESCRIPTION_TEMPO_REQUIRES_WEATHER_CLOUD);
            }
            return tooltip;
        };
    }

    public TempoAbility(AbilityCore core) {
        super(core);
        this.setDisplayIcon(ModResources.TEMPO_ICON);
    }

    @Override
    public void use(LivingEntity entity) {
        AbilityUseEvent.Pre pre = new AbilityUseEvent.Pre(entity, this);
        if (MinecraftForge.EVENT_BUS.post((Event)pre)) {
            return;
        }
        this.useTempo(entity);
        AbilityUseEvent.Post post = new AbilityUseEvent.Post(entity, this);
        MinecraftForge.EVENT_BUS.post((Event)post);
    }

    public void useTempo(LivingEntity entity) {
    }

    @Override
    public AbilityUseResult canUse(LivingEntity entity) {
        return super.canUse(entity);
    }

    public boolean isUnderWeatherCloud(WeatherCloudEntity cloud, LivingEntity target) {
        Vector3d cloudPos = new Vector3d(cloud.func_226277_ct_(), target.func_226278_cu_(), cloud.func_226281_cx_());
        return Math.sqrt(target.func_195048_a(cloudPos)) < (double)(cloud.func_213305_a((Pose)Pose.STANDING).field_220315_a / 2.0f);
    }
}

