/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import net.minecraft.entity.LivingEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class AnimeScreamComponent
extends AbilityComponent<IAbility> {
    private static final Ability.IOnUse2Event<LivingEntity, IAbility> SIMPLE_SCREAM = (e, a) -> a.getComponent(ModAbilityKeys.ANIME_SCREAM).ifPresent(comp -> comp.scream(e));

    public AnimeScreamComponent(IAbility ability) {
        super(ModAbilityKeys.ANIME_SCREAM, ability);
    }

    public void setupDefaultScreams(IAbility ability) {
        if (ability.hasComponent(ModAbilityKeys.CHARGE)) {
            ChargeComponent comp = ability.getComponent(ModAbilityKeys.CHARGE).get();
            String[] split = this.getAbility().getDisplayName().getString().split(" ", 0);
            comp.addStartEvent((e, a) -> this.scream(e, split[0] + (split.length > 1 ? "..." : "")));
            if (split.length > 1) {
                StringBuilder endMessage = new StringBuilder();
                for (int i = 1; i < split.length; ++i) {
                    endMessage.append(split[i]);
                    if (i >= split.length - 1) continue;
                    endMessage.append(" ");
                }
                comp.addEndEvent((e, a) -> this.scream(e, "..." + endMessage.toString()));
            }
        } else if (ability.hasComponent(ModAbilityKeys.CONTINUOUS)) {
            ContinuousComponent comp = ability.getComponent(ModAbilityKeys.CONTINUOUS).get();
            comp.addStartEvent((e, a) -> this.scream(e));
        } else if (ability instanceof Ability && !((Ability)ability).hasUseEvent(SIMPLE_SCREAM)) {
            ((Ability)ability).addUseEvent(SIMPLE_SCREAM);
        }
    }

    public void scream(LivingEntity entity) {
        this.scream(entity, this.getAbility().getDisplayName().getString());
    }

    public void scream(LivingEntity entity, String message) {
        this.ensureIsRegistered();
        if (!entity.field_70170_p.field_72995_K && ((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue()) {
            World world = entity.func_130014_f_();
            IFormattableTextComponent itextcomponent = new TranslationTextComponent("chat.type.text", new Object[]{entity.func_145748_c_(), ForgeHooks.newChatWithLinks((String)message.toUpperCase())}).func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)));
            world.func_73046_m().func_184103_al().func_148543_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 100.0, world.func_234923_W_(), (IPacket)new SChatPacket((ITextComponent)itextcomponent, ChatType.CHAT, entity.func_110124_au()));
        }
    }
}

