/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class ChangeStatsComponent
extends AbilityComponent<IAbility> {
    private Map<Attribute, Pair<Predicate<LivingEntity>, AttributeModifier>> modifiers = new HashMap<Attribute, Pair<Predicate<LivingEntity>, AttributeModifier>>();
    private boolean hasModsApplied;

    public static AbilityDescriptionLine.IDescriptionLine getTooltip() {
        return (e, a) -> {
            Optional<ChangeStatsComponent> comp = a.getComponent(ModAbilityKeys.CHANGE_STATS);
            if (comp.isPresent()) {
                ITextComponent[] lines = new ITextComponent[comp.get().modifiers.size() + 1];
                int lineId = 0;
                lines[lineId++] = new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r");
                for (Map.Entry<Attribute, Pair<Predicate<LivingEntity>, AttributeModifier>> entry : comp.get().modifiers.entrySet()) {
                    AttributeModifier mod = (AttributeModifier)entry.getValue().getRight();
                    float value = (float)mod.func_111164_d();
                    boolean isBuff = value > 0.0f;
                    TranslationTextComponent attrName = new TranslationTextComponent(entry.getKey().func_233754_c_());
                    String op = "";
                    switch (mod.func_220375_c()) {
                        case ADDITION: {
                            op = isBuff ? "+" : "";
                            break;
                        }
                        case MULTIPLY_BASE: {
                            double base = entry.getKey().func_111110_b();
                            value = (float)(base * mod.func_111164_d());
                            op = isBuff ? "+" : "";
                            break;
                        }
                        case MULTIPLY_TOTAL: {
                            op = "x";
                            value = (float)(1.0 + mod.func_111164_d());
                            break;
                        }
                    }
                    ITextComponent statText = new AbilityStat.Builder((ITextComponent)attrName, value).withSign(op).withBuff(isBuff).build().getStatDescription(2);
                    lines[lineId++] = statText;
                }
                StringBuilder sb = new StringBuilder();
                lineId = 0;
                for (ITextComponent text : lines) {
                    boolean hasFollowingLine = lineId++ < lines.length - 1;
                    sb.append(text.getString() + (hasFollowingLine ? "\n" : ""));
                }
                return new StringTextComponent(sb.toString());
            }
            return null;
        };
    }

    public ChangeStatsComponent(IAbility ability) {
        super(ModAbilityKeys.CHANGE_STATS, ability);
    }

    public ChangeStatsComponent addAttributeModifier(Supplier<Attribute> attr, AttributeModifier modifier) {
        return this.addAttributeModifier(attr, modifier, null);
    }

    public ChangeStatsComponent addAttributeModifier(Attribute attr, AttributeModifier modifier) {
        return this.addAttributeModifier(attr, modifier, null);
    }

    public ChangeStatsComponent addAttributeModifier(Attribute attr, AttributeModifier modifier, @Nullable Predicate<LivingEntity> test) {
        this.removeAttributeModifier(attr);
        this.modifiers.put(attr, (Pair<Predicate<LivingEntity>, AttributeModifier>)ImmutablePair.of(test, (Object)modifier));
        return this;
    }

    public ChangeStatsComponent addAttributeModifier(Supplier<Attribute> attr, AttributeModifier modifier, @Nullable Predicate<LivingEntity> test) {
        return this.addAttributeModifier(attr.get(), modifier, test);
    }

    public ChangeStatsComponent removeAttributeModifier(Attribute attr) {
        this.modifiers.remove(attr);
        return this;
    }

    public ChangeStatsComponent removeAttributeModifier(Supplier<Attribute> attr) {
        return this.removeAttributeModifier(attr.get());
    }

    public void clearAttributeModifiers() {
        this.modifiers.clear();
    }

    public void applyModifiers(LivingEntity entity) {
        for (Map.Entry<Attribute, Pair<Predicate<LivingEntity>, AttributeModifier>> entry : this.modifiers.entrySet()) {
            this.applyModifier(entity, entry.getKey(), (AttributeModifier)entry.getValue().getRight());
        }
        this.hasModsApplied = true;
    }

    private void applyMissingModifier(LivingEntity entity, Attribute attr, AttributeModifier modifier) {
        if (!this.hasModifier(entity, attr, modifier.func_111167_a())) {
            this.applyModifier(entity, attr, modifier);
        }
        this.hasModsApplied = true;
    }

    private void applyModifier(LivingEntity entity, Attribute attr, AttributeModifier modifier) {
        this.ensureIsRegistered();
        if (modifier instanceof AbilityAttributeModifier && !((AbilityAttributeModifier)modifier).getAbilityCore().equals(this.getAbility().getCore())) {
            return;
        }
        ModifiableAttributeInstance modAttr = entity.func_110148_a(attr);
        if (modAttr != null) {
            modAttr.func_111124_b(modifier);
            modAttr.func_233767_b_(modifier);
        }
    }

    public void removeModifiers(LivingEntity entity) {
        if (!this.hasModsApplied) {
            return;
        }
        for (Map.Entry<Attribute, Pair<Predicate<LivingEntity>, AttributeModifier>> entry : this.modifiers.entrySet()) {
            this.removeModifier(entity, entry.getKey(), (AttributeModifier)entry.getValue().getRight());
        }
        this.hasModsApplied = false;
    }

    public void removeModifier(LivingEntity entity, Attribute attr, AttributeModifier modifier) {
        this.removeModifier(entity, attr, modifier.func_111167_a());
    }

    public void removeModifier(LivingEntity entity, Attribute attr, UUID id) {
        ModifiableAttributeInstance modAttr = entity.func_110148_a(attr);
        if (this.hasModsApplied && modAttr != null) {
            float leftHp;
            AttributeModifier modifier = modAttr.func_111127_a(id);
            if (modifier instanceof AbilityAttributeModifier && !((AbilityAttributeModifier)modifier).getAbilityCore().equals(this.getAbility().getCore())) {
                return;
            }
            modAttr.func_188479_b(id);
            if (attr.equals(Attributes.field_233818_a_) && (leftHp = entity.func_110143_aJ() - entity.func_110138_aP()) > 0.0f) {
                entity.func_70606_j(entity.func_110143_aJ() - leftHp);
            }
        }
    }

    private boolean hasModifier(LivingEntity entity, Attribute attr, UUID id) {
        ModifiableAttributeInstance modAttr = entity.func_110148_a(attr);
        if (modAttr == null) {
            return false;
        }
        return modAttr.func_111127_a(id) != null;
    }

    @Override
    protected void doTick(LivingEntity entity) {
        this.modifiers.forEach((attr, pair) -> {
            if (pair.getLeft() != null) {
                if (((Predicate)pair.getLeft()).test(entity)) {
                    this.applyMissingModifier(entity, (Attribute)attr, (AttributeModifier)pair.getRight());
                } else {
                    this.removeModifier(entity, (Attribute)attr, (AttributeModifier)pair.getRight());
                }
            }
        });
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74757_a("hasModsApplied", this.hasModsApplied);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasModsApplied = nbt.func_74767_n("hasModsApplied");
    }
}

