/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DisableComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStartContinuityPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SStopContinuityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ContinuousComponent
extends AbilityComponent<IAbility> {
    private static final TranslationTextComponent CONTINUITY_STAT = new TranslationTextComponent(ModI18n.ABILITY_DESCRIPTION_STAT_NAME_CONTINUE);
    private boolean isContinuous;
    private float thresholdTime;
    private float continueTime;
    private boolean isInfinite;
    private final boolean isParallel;
    private final Predicate<ContinuousComponent> isParallelTest;
    private final PriorityEventPool<IStartContinuousEvent> startContinuousEvents = new PriorityEventPool();
    private final PriorityEventPool<IDuringContinuousEvent> tickContinuousEvents = new PriorityEventPool();
    private final PriorityEventPool<IEndContinuousEvent> stopContinuousEvents = new PriorityEventPool();

    public static AbilityDescriptionLine.IDescriptionLine getTooltip() {
        return ContinuousComponent.getTooltip(-1.0f);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float ticks) {
        return ContinuousComponent.getTooltip(ticks, ticks);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max) {
        return (e, a) -> {
            float minVal = min;
            float maxVal = max;
            if (min == max && min == -1.0f) {
                minVal = Float.POSITIVE_INFINITY;
                maxVal = Float.POSITIVE_INFINITY;
            } else {
                minVal = Math.round(min / 20.0f);
                maxVal = Math.round(max / 20.0f);
            }
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)CONTINUITY_STAT, minVal, maxVal).withUnit((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_UNIT_SECONDS);
            return statBuilder.build().getStatDescription();
        };
    }

    public ContinuousComponent(IAbility ability) {
        this(ability, false);
    }

    public ContinuousComponent(IAbility ability, boolean isParallel) {
        super(ModAbilityKeys.CONTINUOUS, ability);
        this.isParallel = isParallel;
        this.isParallelTest = comp -> true;
    }

    public ContinuousComponent(IAbility ability, Predicate<ContinuousComponent> isParallelTest) {
        super(ModAbilityKeys.CONTINUOUS, ability);
        this.isParallel = true;
        this.isParallelTest = isParallelTest;
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPreRenderEvent(200, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.isContinuous()) {
                component.setMaxValue(this.thresholdTime);
                component.setCurrentValue(this.thresholdTime - this.continueTime);
                if (ClientConfig.INSTANCE.isDisplayInPercentage()) {
                    float percentage = (this.thresholdTime - this.continueTime) / this.thresholdTime * 100.0f;
                    percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)100.0f);
                    String percentageText = String.format("%.0f", Float.valueOf(percentage)) + "%";
                    component.setDisplayText(percentageText);
                }
                component.setSlotColor(0.0f, 0.0f, 1.0f);
            }
        }));
    }

    @Override
    protected void doTick(LivingEntity entity) {
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return;
        }
        this.getAbility().getComponent(ModAbilityKeys.ALT_MODE).ifPresent(component -> component.setDisabled(this.isContinuous()));
        if (this.isContinuous()) {
            ProtectedAreasData worldData;
            ProtectedArea area;
            if (entity.func_70644_a((Effect)ModEffects.IN_EVENT.get())) {
                this.stopContinuity(entity);
                return;
            }
            if (!entity.field_70170_p.field_72995_K && (area = (worldData = ProtectedAreasData.get(entity.field_70170_p)).getProtectedArea(entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177956_o(), entity.func_233580_cy_().func_177952_p())) != null && !area.canUseAbility(this.getAbility().getCore())) {
                this.stopContinuity(entity);
                return;
            }
            if (!this.isInfinite && this.continueTime >= this.thresholdTime) {
                this.stopContinuity(entity);
                return;
            }
            ModifiableAttributeInstance inst = entity.func_110148_a((Attribute)ModAttributes.TIME_PROGRESSION.get());
            double timeProgression = 1.0;
            if (inst != null) {
                timeProgression = inst.func_111126_e();
            }
            this.continueTime = (float)((double)this.continueTime + 1.0 * timeProgression);
            this.tickContinuousEvents.dispatch(event -> event.duringContinuous(entity, (IAbility)this.getAbility()));
        }
    }

    public <T extends LivingEntity, A extends IAbility> ContinuousComponent addStartEvent(IStartContinuousEvent event) {
        this.startContinuousEvents.addEvent(event);
        return this;
    }

    public <T extends LivingEntity> ContinuousComponent addStartEvent(int priority, IStartContinuousEvent event) {
        this.startContinuousEvents.addEvent(priority, event);
        return this;
    }

    public <T extends LivingEntity> ContinuousComponent addTickEvent(IDuringContinuousEvent event) {
        this.tickContinuousEvents.addEvent(event);
        return this;
    }

    public <T extends LivingEntity> ContinuousComponent addTickEvent(int priority, IDuringContinuousEvent event) {
        this.tickContinuousEvents.addEvent(priority, event);
        return this;
    }

    public <T extends LivingEntity> ContinuousComponent addEndEvent(IEndContinuousEvent event) {
        this.stopContinuousEvents.addEvent(event);
        return this;
    }

    public <T extends LivingEntity> ContinuousComponent addEndEvent(int priority, IEndContinuousEvent event) {
        this.stopContinuousEvents.addEvent(priority, event);
        return this;
    }

    public void triggerContinuity(LivingEntity entity) {
        this.triggerContinuity(entity, -1.0f);
    }

    public void triggerContinuity(LivingEntity entity, float threshold) {
        if (this.isContinuous()) {
            this.stopContinuity(entity);
        } else {
            this.startContinuity(entity, threshold);
        }
    }

    public void startContinuity(LivingEntity entity) {
        this.startContinuity(entity, -1.0f);
    }

    public void startContinuity(LivingEntity entity, float threshold) {
        this.ensureIsRegistered();
        if (this.isContinuous()) {
            return;
        }
        Optional<CooldownComponent> cooldownComponent = this.getAbility().getComponent(ModAbilityKeys.COOLDOWN);
        if (cooldownComponent.isPresent() && cooldownComponent.get().isOnCooldown()) {
            return;
        }
        Optional<DisableComponent> disableComponent = this.getAbility().getComponent(ModAbilityKeys.DISABLE);
        if (disableComponent.isPresent() && disableComponent.get().isDisabled()) {
            return;
        }
        Optional<PoolComponent> poolComponent = this.getAbility().getComponent(ModAbilityKeys.POOL);
        if (poolComponent.isPresent() && poolComponent.get().isPoolInUse()) {
            return;
        }
        this.isInfinite = threshold < 0.0f;
        this.thresholdTime = threshold;
        this.continueTime = 0.0f;
        this.isContinuous = true;
        if (!entity.field_70170_p.field_72995_K) {
            poolComponent.ifPresent(c -> c.startPoolInUse(entity));
        }
        this.startContinuousEvents.dispatch(event -> event.startContinuous(entity, (IAbility)this.getAbility()));
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStartContinuityPacket(entity, (IAbility)this.getAbility(), threshold), entity);
        }
    }

    public void stopContinuity(LivingEntity entity) {
        if (!this.isContinuous) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            this.getAbility().getComponent(ModAbilityKeys.POOL).ifPresent(c -> c.stopPoolInUse(entity));
        }
        this.stopContinuousEvents.dispatch(event -> event.endContinuous(entity, (IAbility)this.getAbility()));
        this.isContinuous = false;
        this.continueTime = 0.0f;
        this.thresholdTime = 0.0f;
        this.getAbility().getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(c -> c.resetDecoration());
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SStopContinuityPacket(entity, (IAbility)this.getAbility()), entity);
        }
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public float getThresholdTime() {
        return this.thresholdTime;
    }

    public float getContinueTime() {
        return this.continueTime;
    }

    public void increaseContinuityTime(float time) {
        this.continueTime += time;
        this.continueTime = MathHelper.func_76131_a((float)this.continueTime, (float)0.0f, (float)this.thresholdTime);
    }

    public void decreaseContinuityTime(float time) {
        this.continueTime -= time;
        this.continueTime = MathHelper.func_76131_a((float)this.continueTime, (float)0.0f, (float)this.thresholdTime);
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public boolean isParallel() {
        return this.isParallel && this.isParallelTest.test(this);
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74776_a("continueTime", this.getContinueTime());
        nbt.func_74776_a("thresholdTime", this.getThresholdTime());
        nbt.func_74757_a("isInfinite", this.isInfinite());
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.continueTime = nbt.func_74760_g("continueTime");
        this.thresholdTime = nbt.func_74760_g("thresholdTime");
        this.isInfinite = nbt.func_74767_n("isInfinite");
        if (this.continueTime > 0.0f) {
            this.isContinuous = true;
        }
    }

    @FunctionalInterface
    public static interface IEndContinuousEvent {
        public void endContinuous(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IDuringContinuousEvent {
        public void duringContinuous(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IStartContinuousEvent {
        public void startContinuous(LivingEntity var1, IAbility var2);
    }
}

