/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class DamageTakenComponent
extends AbilityComponent<IAbility> {
    private float damage;
    private DamageState state;
    private IOnDamageTaken onDamageTakenEvent;

    public DamageTakenComponent(IAbility ability, IOnDamageTaken event, DamageState state) {
        super(ModAbilityKeys.DAMAGE_TAKEN, ability);
        this.state = state;
        this.onDamageTakenEvent = event;
    }

    public void setAmount(float amount) {
        this.damage = amount;
    }

    public float getAmount() {
        return this.damage;
    }

    public DamageState getDamageState() {
        return this.state;
    }

    public float isDamageTaken(LivingEntity entity, DamageSource damageSource, float damage) {
        this.ensureIsRegistered();
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return damage;
        }
        if (this.getAbility().hasComponent(ModAbilityKeys.PAUSE_TICK) && this.getAbility().getComponent(ModAbilityKeys.PAUSE_TICK).get().isPaused()) {
            return damage;
        }
        return this.onDamageTakenEvent.damageCheck(entity, (IAbility)this.getAbility(), damageSource, damage);
    }

    public static enum DamageState {
        ATTACK,
        HURT,
        DAMAGE;

    }

    @FunctionalInterface
    public static interface IOnDamageTaken {
        public float damageCheck(LivingEntity var1, IAbility var2, DamageSource var3, float var4);
    }
}

