/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GrabEntityComponent
extends AbilityComponent<IAbility> {
    private LivingEntity grabbedEntity = null;
    private boolean handleTargetCamera = false;
    private boolean handleTargetPosition = false;
    private float heldDistance = 1.0f;
    private float startHealth;
    private final PriorityEventPool<IOnGrabEvent> grabEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnReleaseEvent> releaseEvents = new PriorityEventPool();

    public GrabEntityComponent(IAbility ability, boolean handleTargetCamera, boolean handleTargetPosition, float heldDistance) {
        super(ModAbilityKeys.GRAB, ability);
        this.handleTargetCamera = handleTargetCamera;
        this.handleTargetPosition = handleTargetPosition;
        this.heldDistance = heldDistance;
    }

    public GrabEntityComponent addGrabEvent(int priority, IOnGrabEvent event) {
        this.grabEvents.addEvent(priority, event);
        return this;
    }

    public GrabEntityComponent addReleaseEvent(int priority, IOnReleaseEvent event) {
        this.releaseEvents.addEvent(priority, event);
        return this;
    }

    @Override
    public void doTick(LivingEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.canContinueGrab(entity)) {
            if (this.handleTargetCamera) {
                this.grabbedEntity.field_70125_A = this.grabbedEntity.field_70127_C;
                this.grabbedEntity.field_70177_z = this.grabbedEntity.field_70126_B;
                if (this.grabbedEntity instanceof PlayerEntity) {
                    EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                    ((ServerPlayerEntity)this.grabbedEntity).field_71135_a.func_175089_a(this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), this.grabbedEntity.field_70126_B, this.grabbedEntity.field_70127_C, flags);
                }
            }
            if (this.handleTargetPosition) {
                this.grabbedEntity.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 5, 3));
                Vector3d lookVec = entity.func_70040_Z();
                Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * (double)this.heldDistance, entity.func_226280_cw_() - 1.0 + lookVec.field_72448_b * (double)this.heldDistance, entity.func_226281_cx_() + lookVec.field_72449_c * (double)this.heldDistance);
                if (!entity.field_70170_p.func_180495_p(new BlockPos(pos)).func_185904_a().func_76220_a()) {
                    this.grabbedEntity.func_225653_b_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                }
                this.grabbedEntity.field_70143_R = 0.0f;
            }
        } else {
            this.release(entity);
        }
    }

    public void release(LivingEntity entity) {
        if (this.grabbedEntity != null && this.grabbedEntity.func_70089_S()) {
            this.grabbedEntity = null;
            this.releaseEvents.dispatch(event -> event.release(entity, this.grabbedEntity, (IAbility)this.getAbility()));
        }
    }

    public boolean grabManually(LivingEntity entity, LivingEntity target) {
        this.ensureIsRegistered();
        if (target != null && target.func_70089_S() && !AbilityHelper.isTargetBlocking(entity, target)) {
            boolean flag;
            boolean bl = flag = !this.grabEvents.dispatchCancelable(event -> !event.grab(entity, target, (IAbility)this.getAbility()));
            if (flag) {
                this.grabbedEntity = target;
                this.startHealth = entity.func_110143_aJ();
                return true;
            }
        }
        return false;
    }

    public boolean grabNearest(LivingEntity entity) {
        double reach = Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, 3.0));
        return this.grabNearest(entity, (float)reach, 0.4f, true);
    }

    public boolean grabNearest(LivingEntity entity, boolean sendFailMessage) {
        double reach = Math.sqrt(AttributeHelper.getSquaredAttackRangeDistance(entity, 3.0));
        return this.grabNearest(entity, (float)reach, 0.4f, sendFailMessage);
    }

    public boolean grabNearest(LivingEntity entity, float distance, float size) {
        return this.grabNearest(entity, distance, size, true);
    }

    public boolean grabNearest(LivingEntity entity, float distance, float size, boolean sendFailMessage) {
        boolean flag;
        this.ensureIsRegistered();
        LivingEntity target = AbilityHelper.canGrab(entity, distance, size, sendFailMessage);
        boolean bl = flag = !this.grabEvents.dispatchCancelable(event -> !event.grab(entity, target, (IAbility)this.getAbility()));
        if (flag && target != null && target.func_70089_S()) {
            this.grabbedEntity = target;
            this.startHealth = entity.func_110143_aJ();
            return true;
        }
        return false;
    }

    public boolean canContinueGrab(LivingEntity entity) {
        if (this.grabbedEntity == null || !this.grabbedEntity.func_70089_S()) {
            return false;
        }
        if (AbilityHelper.isDodging(this.grabbedEntity)) {
            return false;
        }
        if (AbilityHelper.isLogiaBlocking((Entity)entity, this.grabbedEntity)) {
            return false;
        }
        return !(entity.func_110143_aJ() < this.startHealth - 10.0f);
    }

    @Nullable
    public LivingEntity getGrabbedEntity() {
        return this.grabbedEntity;
    }

    public boolean hasGrabbedEntity() {
        return this.grabbedEntity != null && this.grabbedEntity.func_70089_S();
    }

    @FunctionalInterface
    public static interface IOnReleaseEvent {
        public void release(LivingEntity var1, LivingEntity var2, IAbility var3);
    }

    @FunctionalInterface
    public static interface IOnGrabEvent {
        public boolean grab(LivingEntity var1, LivingEntity var2, IAbility var3);
    }
}

