/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;

public class HitTriggerComponent
extends AbilityComponent<IAbility> {
    private static final BiFunction<EventReduce, HitResult, EventReduce> ACCUMULATOR = (total, next) -> {
        if (next == HitResult.FAIL) {
            ++total.fails;
        } else if (next == HitResult.HIT) {
            ++total.hits;
        }
        return total;
    };
    private static final BinaryOperator<EventReduce> COMBINER = (a, b) -> {
        a.fails += b.fails;
        a.hits += b.hits;
        return a;
    };
    private final PriorityEventPool<ITryHitEvent> tryHitEvents = new PriorityEventPool();
    private final PriorityEventPool<IOnHitEvent> onHitEvents = new PriorityEventPool();
    private boolean bypassSameGroupProtection;

    public HitTriggerComponent(IAbility ability) {
        super(ModAbilityKeys.HIT_TRIGGER, ability);
    }

    public HitTriggerComponent setBypassSameGroupProtection() {
        this.bypassSameGroupProtection = true;
        return this;
    }

    public HitTriggerComponent addTryHitEvent(ITryHitEvent event) {
        this.tryHitEvents.addEvent(100, event);
        return this;
    }

    public HitTriggerComponent addTryHitEvent(int priority, ITryHitEvent event) {
        this.tryHitEvents.addEvent(priority, event);
        return this;
    }

    public HitTriggerComponent addOnHitEvent(IOnHitEvent event) {
        this.onHitEvents.addEvent(100, event);
        return this;
    }

    public HitTriggerComponent addOnHitEvent(int priority, IOnHitEvent event) {
        this.onHitEvents.addEvent(priority, event);
        return this;
    }

    public HitResult tryHit(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.ensureIsRegistered();
        if (this.tryHitEvents.getEventsStream().count() <= 0L) {
            return HitResult.HIT;
        }
        Stream<ITryHitEvent> eventStream = this.tryHitEvents.getEventsStream();
        Stream<HitResult> hitResults = eventStream.map(event -> event.tryHit(entity, target, source, (IAbility)this.getAbility()));
        EventReduce result = hitResults.reduce(new EventReduce(), ACCUMULATOR, COMBINER);
        if (result.fails > 0) {
            return HitResult.FAIL;
        }
        if (result.hits > 0) {
            if (this.bypassSameGroupProtection) {
                source.setBypassFriendlyDamage();
            }
            return HitResult.HIT;
        }
        return HitResult.PASS;
    }

    public void onHit(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        this.ensureIsRegistered();
        this.onHitEvents.dispatch(event -> event.onHit(entity, target, source, (IAbility)this.getAbility()));
    }

    public boolean bypassesSameGroupProtection() {
        return this.bypassSameGroupProtection;
    }

    static class EventReduce {
        public int fails;
        public int hits;

        EventReduce() {
        }

        public String toString() {
            return "fails: " + this.fails + ", hits: " + this.hits;
        }
    }

    public static enum HitResult {
        HIT,
        PASS,
        FAIL;

    }

    @FunctionalInterface
    public static interface ITryHitEvent {
        public HitResult tryHit(LivingEntity var1, LivingEntity var2, ModDamageSource var3, IAbility var4);
    }

    @FunctionalInterface
    public static interface IOnHitEvent {
        public void onHit(LivingEntity var1, LivingEntity var2, ModDamageSource var3, IAbility var4);
    }
}

