/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SSetPoolInUsePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class PoolComponent
extends AbilityComponent<IAbility> {
    private final Set<AbilityPool2> pools;
    private boolean poolInUse;
    private float ticksLocked;
    private Predicate<IAbility> predicate;

    public PoolComponent(IAbility ability, AbilityPool2 pool, AbilityPool2 ... pools) {
        super(ModAbilityKeys.POOL, ability);
        this.pools = Sets.newHashSet((Object[])new AbilityPool2[]{pool});
        Collections.addAll(this.pools, pools);
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPreRenderEvent(500, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.isPoolInUse()) {
                float startCooldown = ability.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> Float.valueOf(comp.getStartCooldown())).orElse(Float.valueOf(0.0f)).floatValue();
                if (startCooldown > 0.0f) {
                    float cooldown = ability.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> Float.valueOf(comp.getCooldown())).orElse(Float.valueOf(0.0f)).floatValue();
                    component.setMaxValue(startCooldown);
                    component.setCurrentValue(cooldown);
                    if (ClientConfig.INSTANCE.isDisplayInPercentage()) {
                        float percentage = cooldown / startCooldown * 100.0f;
                        percentage = MathHelper.func_76131_a((float)percentage, (float)0.0f, (float)100.0f);
                        String percentageText = String.format("%.0f", Float.valueOf(percentage)) + "%";
                        component.setDisplayText(percentageText);
                    }
                } else {
                    component.setCurrentValue(0.0f);
                    component.setMaxValue(1.0f);
                }
                component.setSlotColor(0.0f, 0.0f, 0.0f);
                component.setIconColor(0.4f, 0.4f, 0.4f);
            }
        }));
        this.pools.forEach(pool -> pool.addAbilityCore(ability.getCore()));
        this.predicate = abl -> {
            if (abl.equals(ability)) {
                return false;
            }
            Optional<PoolComponent> poolComponent = abl.getComponent(ModAbilityKeys.POOL);
            return poolComponent.isPresent() && this.hasAtLeastOneSamePool(poolComponent.get());
        };
    }

    @Override
    protected void doTick(LivingEntity entity) {
        if (this.getAbility().hasComponent(ModAbilityKeys.DISABLE) && this.getAbility().getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
            return;
        }
    }

    public Set<AbilityPool2> getPools() {
        return this.pools;
    }

    public boolean containsPool(AbilityPool2 pool) {
        for (AbilityPool2 ablpool : this.pools) {
            if (!ablpool.equals(pool)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAtLeastOneSamePool(PoolComponent otherComponent) {
        for (AbilityPool2 p1 : this.pools) {
            for (AbilityPool2 p2 : otherComponent.getPools()) {
                if (!p1.equals(p2)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<IAbility> getAbilitiesInPool(LivingEntity entity) {
        return AbilityDataCapability.get(entity).getEquippedAbilities(this.predicate);
    }

    public boolean isPoolInUse() {
        return this.poolInUse;
    }

    public void setAbilityFromPoolInUse(LivingEntity entity, boolean flag) {
        this.poolInUse = flag;
        if (!flag) {
            this.getAbility().getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(c -> c.resetDecoration());
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SSetPoolInUsePacket(entity, (IAbility)this.getAbility(), flag, 0), entity);
        }
    }

    public void startPoolInUse(LivingEntity entity) {
        this.ensureIsRegistered();
        this.getAbilitiesInPool(entity).forEach(otherAbility -> otherAbility.getComponent(ModAbilityKeys.POOL).ifPresent(c -> c.setAbilityFromPoolInUse(entity, true)));
    }

    public void stopPoolInUse(LivingEntity entity) {
        this.ensureIsRegistered();
        this.getAbilitiesInPool(entity).forEach(otherAbility -> otherAbility.getComponent(ModAbilityKeys.POOL).ifPresent(c -> c.setAbilityFromPoolInUse(entity, false)));
    }
}

