/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class RequireAbilityComponent
extends AbilityComponent<IAbility> {
    public static final IRequireAbilityCheck<?> IS_ACTIVE = (entity, core) -> {
        Object ability = AbilityDataCapability.get(entity).getEquippedAbility(core);
        if (ability != null) {
            return ability.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false);
        }
        return false;
    };
    public static final IRequireAbilityCheck<?> START_IF_NOT_ACTIVE = (entity, core) -> {
        Object ability = AbilityDataCapability.get(entity).getEquippedAbility(core);
        if (ability != null) {
            if (!ability.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false).booleanValue()) {
                ability.use(entity);
            }
            return ability.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous()).orElse(false);
        }
        return false;
    };
    private CheckData[] checks = new CheckData[0];
    private Interval checkInterval = new Interval(10);

    public static AbilityDescriptionLine.IDescriptionLine<IAbility> getTooltip() {
        return (entity, ability) -> {
            TranslationTextComponent tooltip = null;
            Optional<RequireAbilityComponent> comp = ability.getComponent(ModAbilityKeys.REQUIRE_ABILITY);
            if (comp.isPresent()) {
                if (comp.get().checks.length == 1) {
                    tooltip = new TranslationTextComponent(ModI18n.ABILITY_DEPENDENCY_SINGLE_ACTIVE, new Object[]{AbilityHelper.mentionAbility(comp.get().checks[0].ability).getString()});
                } else if (comp.get().checks.length > 1) {
                    tooltip = new TranslationTextComponent(ModI18n.ABILITY_DEPENDENCY_DOUBLE_ACTIVE, new Object[]{AbilityHelper.mentionAbility(comp.get().checks[0].ability).getString(), AbilityHelper.mentionAbility(comp.get().checks[1].ability).getString()});
                }
            }
            return tooltip;
        };
    }

    public RequireAbilityComponent(IAbility ability, CheckData mainCheck, CheckData ... checks) {
        super(ModAbilityKeys.REQUIRE_ABILITY, ability);
        this.checks = new CheckData[checks.length + 1];
        this.checks[0] = mainCheck;
        int i = 1;
        CheckData[] checkDataArray = checks;
        int n = checkDataArray.length;
        for (int j = 0; j < n; ++j) {
            CheckData check;
            this.checks[i] = check = checkDataArray[j];
            ++i;
        }
    }

    @Override
    protected void doTick(LivingEntity entity) {
        Optional<ContinuousComponent> comp;
        if (this.getAbility().hasComponent(ModAbilityKeys.CONTINUOUS) && (comp = this.getAbility().getComponent(ModAbilityKeys.CONTINUOUS)).isPresent() && comp.get().isContinuous() && this.checkInterval.canTick() && !this.checkRequirements(entity)) {
            comp.get().stopContinuity(entity);
        }
    }

    @Override
    public void postInit(IAbility iability) {
        if (iability instanceof Ability) {
            Ability abl = (Ability)iability;
            abl.addCanUseCheck((entity, ability) -> AbilityHelper.requireAbilityCheck(entity, abl, this.checks));
        }
    }

    public boolean checkRequirements(LivingEntity entity) {
        boolean result = false;
        for (CheckData checkData : this.checks) {
            if (!checkData.checkAbility(entity)) continue;
            result = true;
            break;
        }
        return result;
    }

    @FunctionalInterface
    public static interface IRequireAbilityCheck<A extends IAbility> {
        public boolean checkAbility(LivingEntity var1, AbilityCore<A> var2);
    }

    public static class CheckData<A extends IAbility> {
        private AbilityCore<A> ability;
        private IRequireAbilityCheck<A> check;

        public CheckData(AbilityCore<A> ability, IRequireAbilityCheck<A> check) {
            this.ability = ability;
            this.check = check;
        }

        public AbilityCore<A> getAbility() {
            return this.ability;
        }

        public IRequireAbilityCheck<A> getCheck() {
            return this.check;
        }

        public boolean checkAbility(LivingEntity entity) {
            return this.check.checkAbility(entity, this.ability);
        }
    }
}

