/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SlotDecorationComponent
extends AbilityComponent<IAbility> {
    private static final String FLUSH = "";
    private float slotRed = 1.0f;
    private float slotGreen = 1.0f;
    private float slotBlue = 1.0f;
    private float iconRed = 1.0f;
    private float iconGreen = 1.0f;
    private float iconBlue = 1.0f;
    private float iconAlpha = 1.0f;
    private float maxValue = 1.0f;
    private float currentValue = 0.0f;
    private String displayText = "";
    private final PriorityEventPool<IPreRenderEvent> preRenderEvents = new PriorityEventPool();
    private final PriorityEventPool<IPostRenderEvent> postRenderEvents = new PriorityEventPool();

    public SlotDecorationComponent(IAbility ability) {
        super(ModAbilityKeys.SLOT_DECORATION, ability);
        this.setClientSide();
    }

    @Override
    public void postInit(IAbility ability) {
        this.addPreRenderEvent(999, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (GCDCapability.isOnGCD(entity) && (Integer)GCDCapability.getGCD(entity).getKey() > 0) {
                ImmutablePair<Integer, Integer> pair = GCDCapability.getGCD(entity);
                this.setCurrentValue(((Integer)pair.getKey()).intValue());
                this.setMaxValue(((Integer)pair.getValue()).intValue());
                this.setSlotColor(0.7f, 0.0f, 0.0f);
                this.setIconColor(0.4f, 0.4f, 0.4f);
            }
        });
    }

    public SlotDecorationComponent addPreRenderEvent(int priority, IPreRenderEvent event) {
        this.preRenderEvents.addEvent(priority, event);
        return this;
    }

    public SlotDecorationComponent addPostRenderEvent(int priority, IPostRenderEvent event) {
        this.postRenderEvents.addEvent(priority, event);
        return this;
    }

    public void setSlotColor(float red, float green, float blue) {
        this.slotRed = red;
        this.slotGreen = green;
        this.slotBlue = blue;
    }

    public void setIconColor(float red, float green, float blue) {
        this.iconRed = red;
        this.iconGreen = green;
        this.iconBlue = blue;
    }

    public void setIconAlpha(float alpha) {
        this.iconAlpha = alpha;
    }

    public void setCurrentValue(float value) {
        this.currentValue = value;
        this.displayText = FLUSH;
    }

    public void setDisplayText(String value) {
        this.displayText = value;
    }

    public void setMaxValue(float max) {
        this.maxValue = max;
    }

    public void triggerPreRenderEvents(LivingEntity entity, Minecraft minecraft, MatrixStack matrixStack, float posX, float posY, float partialTicks) {
        this.preRenderEvents.dispatch(event -> event.preRender(entity, minecraft, matrixStack, posX, posY, partialTicks));
    }

    public void triggerPostRenderEvents(LivingEntity entity, Minecraft minecraft, MatrixStack matrixStack, float posX, float posY, float partialTicks) {
        this.postRenderEvents.dispatch(event -> event.postRender(entity, minecraft, matrixStack, posX, posY, partialTicks));
    }

    public float getSlotRed() {
        return this.slotRed;
    }

    public float getSlotGreen() {
        return this.slotGreen;
    }

    public float getSlotBlue() {
        return this.slotBlue;
    }

    public float getIconRed() {
        return this.iconRed;
    }

    public float getIconGreen() {
        return this.iconGreen;
    }

    public float getIconBlue() {
        return this.iconBlue;
    }

    public float getIconAlpha() {
        return this.iconAlpha;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public boolean hasDisplayText() {
        return !Strings.isNullOrEmpty((String)this.displayText);
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void resetDecoration() {
        this.setSlotColor(1.0f, 1.0f, 1.0f);
        this.setIconColor(1.0f, 1.0f, 1.0f);
        this.setIconAlpha(1.0f);
        this.setCurrentValue(0.0f);
    }

    @FunctionalInterface
    public static interface IPostRenderEvent {
        public void postRender(LivingEntity var1, Minecraft var2, MatrixStack var3, float var4, float var5, float var6);
    }

    @FunctionalInterface
    public static interface IPreRenderEvent {
        public void preRender(LivingEntity var1, Minecraft var2, MatrixStack var3, float var4, float var5, float var6);
    }
}

