/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.init.ModAdvancements;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class Challenge {
    private final ChallengeCore<?> core;
    private boolean isComplete;
    private int bestTime;

    public Challenge(ChallengeCore<?> core) {
        this.core = core;
    }

    public String getCategory() {
        return this.core.getCategory();
    }

    public void resetBestTime() {
        this.bestTime = 0;
    }

    public void tryUpdateBestTime(int time) {
        if (this.getBestTimeTick() == 0) {
            this.bestTime = time;
            return;
        }
        if (this.isPersonalBest(time)) {
            this.bestTime = time;
        }
    }

    public boolean isPersonalBest(int time) {
        int pb = this.getBestTimeTick();
        return pb > 0 && time < pb;
    }

    public int getBestTimeTick() {
        return this.bestTime;
    }

    public String getFormattedBestTime() {
        return WyHelper.formatTimeMMSS(this.bestTime);
    }

    public void setComplete(PlayerEntity player, boolean flag) {
        this.isComplete = flag;
        if (flag && player instanceof ServerPlayerEntity) {
            ModAdvancements.COMPLETE_CHALLENGE.trigger((ServerPlayerEntity)player, this.core);
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public ChallengeCore getCore() {
        return this.core;
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74757_a("isComplete", this.isComplete);
        nbt.func_74768_a("bestTime", this.bestTime);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        this.isComplete = nbt.func_74767_n("isComplete");
        this.bestTime = nbt.func_74762_e("bestTime");
    }

    public boolean equals(Object challenge) {
        if (challenge instanceof ChallengeCore && ((Object)((Object)((ChallengeCore)((Object)challenge)))).equals((Object)this.getCore())) {
            return true;
        }
        if (!(challenge instanceof Challenge)) {
            return false;
        }
        if (this.getCore() == null || ((Challenge)challenge).getCore() == null) {
            return false;
        }
        return ((Object)((Object)this.getCore())).equals((Object)((Challenge)challenge).getCore());
    }
}

