/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.crew;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.init.ModJollyRogers;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JollyRoger {
    private JollyRogerElement base = ModJollyRogers.BASE_0;
    private JollyRogerElement[] backgrounds = new JollyRogerElement[2];
    private JollyRogerElement[] details = new JollyRogerElement[5];

    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        JollyRogerElement baseElement = this.getBase();
        if (baseElement != null && baseElement.getTexture() != null) {
            CompoundNBT baseNBT = new CompoundNBT();
            baseNBT.func_74778_a("id", baseElement.getTexture().toString());
            baseElement.write(baseNBT);
            nbt.func_218657_a("base", (INBT)baseNBT);
        } else {
            nbt.func_218657_a("base", (INBT)new CompoundNBT());
        }
        try {
            ListNBT backgrounds = new ListNBT();
            for (int i = 0; i < this.getBackgrounds().length; ++i) {
                CompoundNBT backgroundNBT;
                JollyRogerElement bgElement = this.getBackgrounds()[i];
                if (bgElement != null && bgElement.getTexture() != null) {
                    backgroundNBT = new CompoundNBT();
                    backgroundNBT.func_74768_a("slot", i);
                    backgroundNBT.func_74778_a("id", bgElement.getTexture().toString());
                    bgElement.write(backgroundNBT);
                    backgrounds.add((Object)backgroundNBT);
                    continue;
                }
                backgroundNBT = new CompoundNBT();
                backgroundNBT.func_74768_a("slot", i);
                backgrounds.add((Object)backgroundNBT);
            }
            nbt.func_218657_a("backgrounds", (INBT)backgrounds);
            ListNBT details = new ListNBT();
            for (int i = 0; i < this.getDetails().length; ++i) {
                CompoundNBT detailNBT;
                JollyRogerElement detailElement = this.getDetails()[i];
                if (detailElement != null && detailElement.getTexture() != null) {
                    detailNBT = new CompoundNBT();
                    detailNBT.func_74768_a("slot", i);
                    detailNBT.func_74778_a("id", detailElement.getTexture().toString());
                    detailElement.write(detailNBT);
                    details.add((Object)detailNBT);
                    continue;
                }
                detailNBT = new CompoundNBT();
                detailNBT.func_74768_a("slot", i);
                details.add((Object)detailNBT);
            }
            nbt.func_218657_a("details", (INBT)details);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        try {
            CompoundNBT baseNBT = nbt.func_74775_l("base");
            if (baseNBT.func_74764_b("id")) {
                JollyRogerElement baseElement = JollyRogerElement.of(new ResourceLocation(baseNBT.func_74779_i("id")));
                if (baseElement != null) {
                    baseElement.read(baseNBT);
                    this.setBase(baseElement);
                }
            } else {
                this.setBase(null);
            }
            ListNBT backgroundsNBT = nbt.func_150295_c("backgrounds", 10);
            for (int i = 0; i < backgroundsNBT.size(); ++i) {
                CompoundNBT backgroundNBT = backgroundsNBT.func_150305_b(i);
                int slot = backgroundNBT.func_74762_e("slot");
                if (backgroundNBT.func_74764_b("id")) {
                    JollyRogerElement bgElement = JollyRogerElement.of(new ResourceLocation(backgroundNBT.func_74779_i("id")));
                    if (bgElement == null) continue;
                    bgElement.read(backgroundNBT);
                    this.setBackground(slot, bgElement);
                    continue;
                }
                this.setBackground(slot, null);
            }
            ListNBT detailsNBT = nbt.func_150295_c("details", 10);
            for (int i = 0; i < detailsNBT.size(); ++i) {
                CompoundNBT detailNBT = detailsNBT.func_150305_b(i);
                int slot = detailNBT.func_74762_e("slot");
                if (detailNBT.func_74764_b("id")) {
                    JollyRogerElement detailElement = JollyRogerElement.of(new ResourceLocation(detailNBT.func_74779_i("id")));
                    if (detailElement == null) continue;
                    detailElement.read(detailNBT);
                    this.setDetail(slot, detailElement);
                    continue;
                }
                this.setDetail(slot, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JollyRogerElement getBase() {
        return this.base;
    }

    public void setBase(JollyRogerElement base) {
        this.base = base;
    }

    public JollyRogerElement[] getBackgrounds() {
        return this.backgrounds;
    }

    public void setBackgrounds(JollyRogerElement[] elements) {
        this.backgrounds = elements;
    }

    public boolean addBackground(JollyRogerElement bg) {
        for (int i = 0; i < this.backgrounds.length; ++i) {
            JollyRogerElement background = this.backgrounds[i];
            if (background != null) continue;
            this.backgrounds[i] = bg;
            return true;
        }
        return false;
    }

    public boolean setBackground(int slot, JollyRogerElement bg) {
        if (!this.hasBackground(bg) && slot <= 2) {
            this.backgrounds[slot] = bg;
            return true;
        }
        return false;
    }

    public boolean hasBackground(JollyRogerElement bg) {
        return ((Stream)Arrays.stream(this.backgrounds).parallel()).anyMatch(background -> background != null && background.equals((Object)bg));
    }

    public JollyRogerElement[] getDetails() {
        return this.details;
    }

    public void setDetails(JollyRogerElement[] elements) {
        this.details = elements;
    }

    public boolean addDetail(JollyRogerElement det) {
        for (int i = 0; i < this.details.length; ++i) {
            JollyRogerElement detail = this.details[i];
            if (detail != null) continue;
            this.details[i] = det;
            return true;
        }
        return false;
    }

    public boolean setDetail(int slot, JollyRogerElement det) {
        if (!this.hasDetail(det) && slot <= 5) {
            this.details[slot] = det;
            return true;
        }
        return false;
    }

    public boolean hasDetail(JollyRogerElement det) {
        return ((Stream)Arrays.stream(this.details).parallel()).anyMatch(detail -> detail != null && detail.equals((Object)det));
    }

    public Optional<BufferedImage> getAsBufferedImage() {
        try {
            BufferedImage jollyRogerImage = new BufferedImage(128, 128, 2);
            for (JollyRogerElement backgroundElement : this.backgrounds) {
                if (backgroundElement == null) continue;
                BufferedImage backgroundElementImage = this.elementToImage(backgroundElement);
                jollyRogerImage.getGraphics().drawImage(backgroundElementImage, 0, 0, null);
            }
            BufferedImage jollyRogerBase = this.elementToImage(this.base);
            jollyRogerImage.getGraphics().drawImage(jollyRogerBase, 0, 0, null);
            for (JollyRogerElement detailElement : this.details) {
                if (detailElement == null) continue;
                BufferedImage detailElementImage = this.elementToImage(detailElement);
                jollyRogerImage.getGraphics().drawImage(detailElementImage, 0, 0, null);
            }
            return Optional.of(jollyRogerImage);
        }
        catch (IOException e) {
            ModMain.LOGGER.error(e.getMessage());
            return Optional.empty();
        }
    }

    private BufferedImage elementToImage(JollyRogerElement element) throws IOException {
        String assetPath = "assets/mineminenomi/";
        BufferedImage elementImage = ImageIO.read(this.getClass().getClassLoader().getResourceAsStream(assetPath + element.getTexture().func_110623_a()));
        if (element.canBeColored()) {
            elementImage = this.applyColorToImage(element.getColor(), elementImage);
        }
        return elementImage;
    }

    private BufferedImage applyColorToImage(String hex, BufferedImage image) {
        Color color = WyHelper.hexToRGB(hex);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgba = image.getRGB(x, y);
                Color pixelColor = new Color(rgba, true);
                if (pixelColor.getAlpha() == 0 || (rgba & 0xFFFFFF) == 0) continue;
                Integer tintedPixel = JollyRoger.tintABGRPixel(pixelColor.getRGB(), color);
                image.setRGB(x, y, tintedPixel);
            }
        }
        return image;
    }

    public static Integer tintABGRPixel(int pixelColor, Color tintColor) {
        int x = pixelColor >> 16 & 0xFF;
        int y = pixelColor >> 8 & 0xFF;
        int z = pixelColor & 0xFF;
        int top = 2126 * x + 7252 * y + 722 * z;
        int Btemp = (int)((long)(tintColor.getBlue() * top) * 1766117501L >> 52);
        int Gtemp = (int)((long)(tintColor.getGreen() * top) * 1766117501L >> 52);
        int Rtemp = (int)((long)(tintColor.getRed() * top) * 1766117501L >> 52);
        return (pixelColor >> 24 & 0xFF) << 24 | Btemp & 0xFF | (Gtemp & 0xFF) << 8 | (Rtemp & 0xFF) << 16;
    }
}

