/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.crew;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.init.ModJollyRogers;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JollyRogerElement
extends ForgeRegistryEntry<JollyRogerElement> {
    private boolean canBeColored = false;
    @Deprecated
    private String color = "#FFFFFF";
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private Color fullColor = new Color(this.red, this.green, this.blue);
    private ResourceLocation texture;
    private List<ICanUse> canUseChecks = new ArrayList<ICanUse>();
    private LayerType type;

    @Deprecated
    public JollyRogerElement(LayerType type) {
        this.type = type;
    }

    public JollyRogerElement(LayerType type, String texture) {
        this.type = type;
        String category = "bases";
        if (type == LayerType.BACKGROUND) {
            category = "backgrounds";
        } else if (type == LayerType.DETAIL) {
            category = "details";
        }
        this.setTexture(new ResourceLocation("mineminenomi", "textures/jolly_rogers/" + category + "/" + texture + ".png"));
        ModJollyRogers.registerElement(this);
    }

    public static JollyRogerElement of(ResourceLocation res) {
        return (JollyRogerElement)ModRegistries.JOLLY_ROGER_ELEMENTS.getValue(res);
    }

    public boolean canBeColored() {
        return this.canBeColored;
    }

    public JollyRogerElement setCanBeColored() {
        this.canBeColored = true;
        return this;
    }

    @Deprecated
    public String getColor() {
        return this.color;
    }

    public Color getFullColor() {
        return this.fullColor;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    @Deprecated
    public JollyRogerElement setColor(String color) {
        this.color = color;
        return this;
    }

    public JollyRogerElement setColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.fullColor = new Color(this.red, this.green, this.blue);
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public JollyRogerElement setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public JollyRogerElement addUseCheck(ICanUse check) {
        this.canUseChecks.add(check);
        return this;
    }

    public boolean canUse(PlayerEntity player, Crew crew) {
        boolean flag = true;
        for (ICanUse check : this.canUseChecks) {
            if (check == null || check.canUse(player, crew)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public LayerType getLayerType() {
        return this.type;
    }

    public boolean equals(Object element) {
        if (!(element instanceof JollyRogerElement) || this.getTexture() == null || ((JollyRogerElement)((Object)element)).getTexture() == null) {
            return false;
        }
        return this.getTexture().toString().equalsIgnoreCase(((JollyRogerElement)((Object)element)).getTexture().toString());
    }

    @Nullable
    public JollyRogerElement create() {
        try {
            return (JollyRogerElement)((Object)((Object)((Object)this)).getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void write(CompoundNBT nbt) {
        nbt.func_74757_a("canBeColored", this.canBeColored());
        nbt.func_74768_a("red", this.red);
        nbt.func_74768_a("green", this.green);
        nbt.func_74768_a("blue", this.blue);
    }

    public void read(CompoundNBT nbt) {
        if (nbt.func_74767_n("canBeColored")) {
            this.setCanBeColored();
        }
        if (nbt.func_150297_b("color", 8)) {
            Color color = WyHelper.hexToRGB(nbt.func_74779_i("color"));
            this.color = null;
            this.setColor(color.getRed(), color.getGreen(), color.getBlue());
        } else {
            int red = nbt.func_74762_e("red");
            int green = nbt.func_74762_e("green");
            int blue = nbt.func_74762_e("blue");
            this.setColor(red, green, blue);
        }
    }

    public static enum LayerType {
        BASE,
        BACKGROUND,
        DETAIL;

    }

    public static interface ICanUse
    extends Serializable {
        public boolean canUse(PlayerEntity var1, Crew var2);
    }
}

