/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.effects;

import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectType;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.effects.ModEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DamageOverTimeEffect
extends ModEffect {
    private final DamageSource source;
    private final float baseDamage;
    private final int freq;
    private Function<Integer, Float> damageFunction;

    public DamageOverTimeEffect() {
        this(DamageSource.field_76376_m, 2.0f, 20);
    }

    public DamageOverTimeEffect(DamageSource source, float baseDamage, int freq) {
        super(EffectType.HARMFUL, WyHelper.hexToRGB("#000000").getRGB());
        this.source = source;
        this.baseDamage = baseDamage;
        this.freq = freq;
        this.damageFunction = amp -> Float.valueOf(this.baseDamage * (float)amp.intValue());
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % this.freq == 0;
    }

    public void func_76394_a(LivingEntity entity, int amplifier) {
        float damage = Math.max(this.baseDamage, this.damageFunction.apply(amplifier).floatValue());
        entity.func_70097_a(this.source, damage);
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public Function<Integer, Float> getDamageFunction() {
        return this.damageFunction;
    }

    public void setDamageFunction(Function<Integer, Float> func) {
        this.damageFunction = func;
    }

    @Override
    public boolean isRemoveable() {
        return false;
    }
}

