/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.TradeEntry;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.trade.SUpdateTraderOffersPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenTraderScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public abstract class TraderEntity
extends OPEntity {
    protected List<TradeEntry> tradeEntries = new ArrayList<TradeEntry>();
    private boolean isTrading = false;
    private boolean canBuy;

    public TraderEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public TraderEntity(EntityType type, World world, ResourceLocation[] textures) {
        super(type, world, textures);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public abstract boolean canTrade(PlayerEntity var1);

    public abstract String getTradeFailMessage();

    public abstract ResourceLocation getTradeTable();

    public abstract Currency getCurrency();

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List customers = WyHelper.getNearbyPlayers(this.func_213303_ch(), (IWorld)this.field_70170_p, 3.0, null);
        if (customers.size() > 0) {
            this.func_200602_a(EntityAnchorArgument.Type.EYES, ((PlayerEntity)customers.get(0)).func_174824_e(0.0f));
            this.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 40, 0, false, false));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ListNBT items = new ListNBT();
        for (TradeEntry stack : this.tradeEntries) {
            CompoundNBT nbtTrade = new CompoundNBT();
            nbtTrade = stack.getItemStack().func_77955_b(nbtTrade);
            items.add((Object)nbtTrade);
        }
        nbt.func_218657_a("Items", (INBT)items);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        ListNBT tradeList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tradeList.size(); ++i) {
            CompoundNBT nbtTrade = tradeList.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbtTrade);
            this.tradeEntries.add(new TradeEntry(stack));
        }
    }

    public void setStacksFromNBT(CompoundNBT nbt) {
        ListNBT tradeList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tradeList.size(); ++i) {
            CompoundNBT nbtTrade = tradeList.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbtTrade);
            this.tradeEntries.add(new TradeEntry(stack));
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        LootTable lootTable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(this.getTradeTable());
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p);
        LootContext context = builder.func_216022_a(LootParameterSets.field_216260_a);
        List stacks = lootTable.func_216113_a(context);
        for (ItemStack stack : stacks) {
            this.tradeEntries.add(new TradeEntry(stack));
        }
        return spawnData;
    }

    public List<TradeEntry> getTradingItems() {
        return this.tradeEntries;
    }

    public void setIsTrading(boolean flag) {
        this.isTrading = flag;
    }

    public void setTradingItems(List<TradeEntry> entries) {
        this.tradeEntries = entries;
    }

    public boolean canBuyFromPlayers() {
        return this.canBuy;
    }

    public void setCanBuyFromPlayers() {
        this.canBuy = true;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SOpenTraderScreenPacket(this.func_145782_y()), player);
            WyNetwork.sendTo(new SUpdateTraderOffersPacket(this.func_145782_y(), this.tradeEntries), player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

